/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SkuHelper.class})
public class SkuHelper {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPInstanceService _cpInstanceService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public Page<Sku> getSkusPage(long id, Locale locale, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id);
        if (cpDefinition == null) {
            return Page.of(Collections.emptyList());
        }
        List cpInstances = this._cpInstanceService.getCPDefinitionInstances(cpDefinition.getCPDefinitionId(), 0, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpInstanceService.getCPDefinitionInstancesCount(cpDefinition.getCPDefinitionId(), 0);
        return Page.of(this.toSKUs(cpInstances, locale), (Pagination)pagination, (long)totalItems);
    }

    public List<Sku> toSKUs(List<CPInstance> cpInstances, Locale locale) throws Exception {
        ArrayList<Sku> skus = new ArrayList<Sku>();
        DTOConverter skuDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPInstance.class.getName());
        for (CPInstance cpInstance : cpInstances) {
            skus.add((Sku)skuDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(locale, cpInstance.getCPInstanceId())));
        }
        return skus;
    }
}

