/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionSpecificationOptionValueException;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.SpecificationValue;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSpecificationValueResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SpecificationValueResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/specification-value.properties"}, scope=ServiceScope.PROTOTYPE, service={SpecificationValueResource.class})
public class SpecificationValueResourceImpl
extends BaseSpecificationValueResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SpecificationValueResourceImpl.class);
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Page<SpecificationValue> getSpecificationIdSpecificationValuesPage(Long id, Pagination pagination) throws Exception {
        DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        Specification specification = (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), (Object)id));
        List cpDefinitionSpecificationOptionValues = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValues(specification.getId().longValue(), pagination.getStartPosition(), pagination.getEndPosition());
        int totalItems = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValuesCount(specification.getId().longValue());
        return Page.of(this._toSpecificationValues(cpDefinitionSpecificationOptionValues), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public SpecificationValue postSpecificationIdSpecificationValue(Long id, SpecificationValue specificationValue) throws Exception {
        return this._upsertSpecificationValue(id, specificationValue);
    }

    private long _getCPDefinitionId(SpecificationValue specificationValue) {
        Product product = specificationValue.getProduct();
        if (product == null) {
            return 0L;
        }
        return product.getId();
    }

    private long _getCPOptionCategoryId(SpecificationValue specificationValue) {
        OptionCategory optionCategory = specificationValue.getOptionCategory();
        if (optionCategory == null) {
            return 0L;
        }
        return optionCategory.getId();
    }

    private long _getCPSpecificationOptionId(SpecificationValue specificationValue) {
        Specification specification = specificationValue.getSpecification();
        if (specification == null) {
            return 0L;
        }
        return specification.getId();
    }

    private List<SpecificationValue> _toSpecificationValues(List<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues) throws Exception {
        ArrayList<SpecificationValue> specificationValues = new ArrayList<SpecificationValue>();
        DTOConverter specificationValueDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionSpecificationOptionValue.class.getName());
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            specificationValues.add((SpecificationValue)specificationValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId())));
        }
        return specificationValues;
    }

    private CPDefinitionSpecificationOptionValue _updateSpecificationValue(Long id, SpecificationValue specificationValue) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(id.longValue());
        return this._cpDefinitionSpecificationOptionValueService.updateCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId(), this._getCPOptionCategoryId(specificationValue), LanguageUtils.getLocalizedMap((Map)specificationValue.getValue()), GetterUtil.get((Object)specificationValue.getPriority(), (double)cpDefinitionSpecificationOptionValue.getPriority()), this._serviceContextHelper.getServiceContext(cpDefinitionSpecificationOptionValue.getGroupId()));
    }

    private SpecificationValue _upsertSpecificationValue(Long specificationId, SpecificationValue specificationValue) throws Exception {
        try {
            CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._updateSpecificationValue(specificationValue.getId(), specificationValue);
            DTOConverter specificationValueDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionSpecificationOptionValue.class.getName());
            return (SpecificationValue)specificationValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId()));
        }
        catch (NoSuchCPDefinitionSpecificationOptionValueException nscpdsove) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find specificationValue with ID: " + specificationValue.getId()));
            }
            CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.getCPSpecificationOption(specificationId.longValue());
            CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.addCPDefinitionSpecificationOptionValue(this._getCPDefinitionId(specificationValue), this._getCPSpecificationOptionId(specificationValue), this._getCPOptionCategoryId(specificationValue), LanguageUtils.getLocalizedMap((Map)specificationValue.getValue()), GetterUtil.get((Object)specificationValue.getPriority(), (double)0.0), this._serviceContextHelper.getServiceContext(cpSpecificationOption.getGroupId()));
            DTOConverter specificationValueDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionSpecificationOptionValue.class.getName());
            return (SpecificationValue)specificationValueDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId()));
        }
    }
}

