/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPSpecificationOptionException;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSpecificationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SpecificationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/specification.properties"}, scope=ServiceScope.PROTOTYPE, service={SpecificationResource.class})
public class SpecificationResourceImpl
extends BaseSpecificationResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(SpecificationResourceImpl.class);
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteSpecification(Long id) throws Exception {
        this._cpSpecificationOptionService.deleteCPSpecificationOption(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Page<Specification> getCatalogSiteSpecificationsPage(Long siteId, Pagination pagination) throws Exception {
        int totalItems = this._cpSpecificationOptionService.getCPSpecificationOptionsCount(siteId.longValue());
        List cpSpecificationOptions = this._cpSpecificationOptionService.getCPSpecificationOptions(siteId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        return Page.of(this._toSpecifications(cpSpecificationOptions), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Specification getSpecification(Long id) throws Exception {
        DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), (Object)id));
    }

    @Override
    public Response patchSpecification(Long id, Specification specification) throws Exception {
        this._updateSpecification(id, specification);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Specification postCatalogSiteSpecification(Long siteId, Specification specification) throws Exception {
        return this._upsertSpecification(siteId, specification);
    }

    private long _getCPOptionCategoryId(Specification specification) {
        OptionCategory optionCategory = specification.getOptionCategory();
        if (optionCategory == null) {
            return 0L;
        }
        return optionCategory.getId();
    }

    private boolean _isFacetable(Specification specification) {
        boolean facetable = false;
        if (specification.getFacetable() != null) {
            facetable = specification.getFacetable();
        }
        return facetable;
    }

    private List<Specification> _toSpecifications(List<CPSpecificationOption> cpSpecificationOptions) throws Exception {
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        for (CPSpecificationOption cpSpecificationOption : cpSpecificationOptions) {
            specifications.add((Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpSpecificationOption.getCPSpecificationOptionId())));
        }
        return specifications;
    }

    private CPSpecificationOption _updateSpecification(Long id, Specification specification) throws PortalException {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.getCPSpecificationOption(id.longValue());
        return this._cpSpecificationOptionService.updateCPSpecificationOption(cpSpecificationOption.getCPSpecificationOptionId(), this._getCPOptionCategoryId(specification), LanguageUtils.getLocalizedMap((Map)specification.getTitle()), LanguageUtils.getLocalizedMap((Map)specification.getDescription()), this._isFacetable(specification), specification.getKey(), this._serviceContextHelper.getServiceContext(cpSpecificationOption.getGroupId()));
    }

    private Specification _upsertSpecification(long siteId, Specification specification) throws Exception {
        DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        try {
            CPSpecificationOption cpSpecificationOption = this._updateSpecification(specification.getId(), specification);
            return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpSpecificationOption.getCPSpecificationOptionId()));
        }
        catch (NoSuchCPSpecificationOptionException nscpsoe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find specification with ID: " + specification.getId()));
            }
            CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.addCPSpecificationOption(this._getCPOptionCategoryId(specification), LanguageUtils.getLocalizedMap((Map)specification.getTitle()), LanguageUtils.getLocalizedMap((Map)specification.getDescription()), this._isFacetable(specification), specification.getKey(), this._serviceContextHelper.getServiceContext(siteId));
            return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpSpecificationOption.getCPSpecificationOptionId()));
        }
    }
}

