/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPSpecificationOption"}, service={DTOConverter.class, SpecificationDTOConverter.class})
public class SpecificationDTOConverter
implements DTOConverter {
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public String getContentType() {
        return Specification.class.getSimpleName();
    }

    public Specification toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.getCPSpecificationOption(dtoConverterContext.getResourcePrimKey());
        final CPOptionCategory cpOptionCategory = cpSpecificationOption.getCPOptionCategory();
        final DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        return new Specification(){
            {
                this.description = LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getDescriptionMap());
                this.facetable = cpSpecificationOption.isFacetable();
                this.id = cpSpecificationOption.getCPSpecificationOptionId();
                this.key = cpSpecificationOption.getKey();
                this.optionCategory = (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpOptionCategory.getCPOptionCategoryId()));
                this.title = LanguageUtils.getLanguageIdMap((Map)cpSpecificationOption.getTitleMap());
            }
        };
    }
}

