/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPOptionCategory"}, service={DTOConverter.class, OptionCategoryDTOConverter.class})
public class OptionCategoryDTOConverter
implements DTOConverter {
    @Reference
    private CPOptionCategoryService _cpOptionCategoryService;

    public String getContentType() {
        return OptionCategory.class.getSimpleName();
    }

    public OptionCategory toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategory(dtoConverterContext.getResourcePrimKey());
        return new OptionCategory(){
            {
                this.description = LanguageUtils.getLanguageIdMap((Map)cpOptionCategory.getDescriptionMap());
                this.id = cpOptionCategory.getCPOptionCategoryId();
                this.key = cpOptionCategory.getKey();
                this.priority = cpOptionCategory.getPriority();
                this.title = LanguageUtils.getLanguageIdMap((Map)cpOptionCategory.getTitleMap());
            }
        };
    }
}

