/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPSpecificationOptionException;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.SpecificationEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseSpecificationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SpecificationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/specification.properties"}, scope=ServiceScope.PROTOTYPE, service={SpecificationResource.class})
public class SpecificationResourceImpl
extends BaseSpecificationResourceImpl
implements EntityModelResource {
    private static final Log _log = LogFactoryUtil.getLog(SpecificationResourceImpl.class);
    private static final EntityModel _entityModel = new SpecificationEntityModel();
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Context
    private User _user;

    @Override
    public Response deleteSpecification(Long id) throws Exception {
        this._cpSpecificationOptionService.deleteCPSpecificationOption(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Specification getSpecification(Long id) throws Exception {
        DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public Page<Specification> getSpecificationsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CPSpecificationOption.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toSpecification(this._cpSpecificationOptionService.getCPSpecificationOption(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public Response patchSpecification(Long id, Specification specification) throws Exception {
        this._updateSpecification(id, specification);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Specification postSpecification(Specification specification) throws Exception {
        return this._upsertSpecification(specification);
    }

    private long _getCPOptionCategoryId(Specification specification) {
        OptionCategory optionCategory = specification.getOptionCategory();
        if (optionCategory == null) {
            return 0L;
        }
        return optionCategory.getId();
    }

    private boolean _isFacetable(Specification specification) {
        boolean facetable = false;
        if (specification.getFacetable() != null) {
            facetable = specification.getFacetable();
        }
        return facetable;
    }

    private Specification _toSpecification(CPSpecificationOption cpSpecificationOption) throws Exception {
        DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpSpecificationOption.getCPSpecificationOptionId()));
    }

    private CPSpecificationOption _updateSpecification(Long id, Specification specification) throws PortalException {
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.getCPSpecificationOption(id.longValue());
        return this._cpSpecificationOptionService.updateCPSpecificationOption(cpSpecificationOption.getCPSpecificationOptionId(), this._getCPOptionCategoryId(specification), LanguageUtils.getLocalizedMap((Map)specification.getTitle()), LanguageUtils.getLocalizedMap((Map)specification.getDescription()), this._isFacetable(specification), specification.getKey(), this._serviceContextHelper.getServiceContext());
    }

    private Specification _upsertSpecification(Specification specification) throws Exception {
        DTOConverter specificationDTOConverter;
        block3: {
            specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
            Long specificationId = specification.getId();
            if (specificationId != null) {
                try {
                    CPSpecificationOption cpSpecificationOption = this._updateSpecification(specificationId, specification);
                    return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpSpecificationOption.getCPSpecificationOptionId()));
                }
                catch (NoSuchCPSpecificationOptionException nscpsoe) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Object)("Unable to find specification with ID: " + specificationId));
                }
            }
        }
        CPSpecificationOption cpSpecificationOption = this._cpSpecificationOptionService.addCPSpecificationOption(this._getCPOptionCategoryId(specification), LanguageUtils.getLocalizedMap((Map)specification.getTitle()), LanguageUtils.getLocalizedMap((Map)specification.getDescription()), this._isFacetable(specification), specification.getKey(), this._serviceContextHelper.getServiceContext());
        return (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpSpecificationOption.getCPSpecificationOptionId()));
    }
}

