/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.helper.v1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ProductHelper.class})
public class ProductHelper {
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;

    public Page<Product> getProductsPage(long companyId, String search, Filter filter, Pagination pagination, Sort[] sorts, UnsafeFunction<Document, Product, Exception> transformUnsafeFunction) throws Exception {
        return SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CPDefinition.class, (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(companyId);
            long[] getCommerceCatalogGroupIds = this._getCommerceCatalogGroupIds(companyId);
            if (getCommerceCatalogGroupIds != null && getCommerceCatalogGroupIds.length > 0) {
                searchContext.setGroupIds(getCommerceCatalogGroupIds);
            }
        }, (Sort[])sorts, transformUnsafeFunction);
    }

    private long[] _getCommerceCatalogGroupIds(long companyId) throws PortalException {
        List commerceCatalogs = this._commerceCatalogLocalService.searchCommerceCatalogs(companyId);
        Stream stream = commerceCatalogs.stream();
        return stream.mapToLong(CommerceCatalog::getGroupId).toArray();
    }
}

