/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.factory;

import com.liferay.headless.commerce.admin.catalog.resource.v1_0.SpecificationResource;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.osgi.service.component.ComponentServiceObjects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceScope;

@Component(immediate=true, service={SpecificationResource.Factory.class})
public class SpecificationResourceFactoryImpl
implements SpecificationResource.Factory {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(scope=ReferenceScope.PROTOTYPE_REQUIRED)
    private ComponentServiceObjects<SpecificationResource> _componentServiceObjects;
    @Reference
    private PermissionCheckerFactory _defaultPermissionCheckerFactory;
    @Reference(target="(permission.checker.type=liberal)")
    private PermissionCheckerFactory _liberalPermissionCheckerFactory;
    @Reference
    private UserLocalService _userLocalService;

    public SpecificationResource.Builder create() {
        return new SpecificationResource.Builder(){
            private boolean _checkPermissions = true;
            private User _user;

            public SpecificationResource build() {
                if (this._user == null) {
                    throw new IllegalArgumentException("User is not set");
                }
                return (SpecificationResource)ProxyUtil.newProxyInstance((ClassLoader)SpecificationResource.class.getClassLoader(), (Class[])new Class[]{SpecificationResource.class}, (proxy, method, arguments) -> SpecificationResourceFactoryImpl.this._invoke(method, arguments, this._checkPermissions, this._user));
            }

            public SpecificationResource.Builder checkPermissions(boolean checkPermissions) {
                this._checkPermissions = checkPermissions;
                return this;
            }

            public SpecificationResource.Builder user(User user) {
                this._user = user;
                return this;
            }
        };
    }

    @Activate
    protected void activate() {
        SpecificationResource.FactoryHolder.factory = this;
    }

    @Deactivate
    protected void deactivate() {
        SpecificationResource.FactoryHolder.factory = null;
    }

    private Object _invoke(Method method, Object[] arguments, boolean checkPermissions, User user) throws Throwable {
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._liberalPermissionCheckerFactory.create(user));
        }
        SpecificationResource specificationResource = (SpecificationResource)this._componentServiceObjects.getService();
        Company company = this._companyLocalService.getCompany(user.getCompanyId());
        specificationResource.setContextCompany(company);
        specificationResource.setContextUser(user);
        try {
            Object object = method.invoke((Object)specificationResource, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            this._componentServiceObjects.ungetService((Object)specificationResource);
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }
}

