/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={CategoryDTOConverter.class, DTOConverter.class})
public class CategoryDTOConverter
implements DTOConverter {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;

    public String getContentType() {
        return Category.class.getSimpleName();
    }

    public Category toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final AssetCategory assetCategory = this._assetCategoryService.getCategory(dtoConverterContext.getResourcePrimKey());
        final AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.getAssetVocabulary(assetCategory.getVocabularyId());
        return new Category(){
            {
                this.externalReferenceCode = assetCategory.getExternalReferenceCode();
                this.id = assetCategory.getCategoryId();
                this.name = assetCategory.getName();
                this.siteId = assetCategory.getGroupId();
                this.vocabulary = assetVocabulary.getName();
            }
        };
    }
}

