/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDefinitionInventoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.model.CPDefinitionInventory"}, service={DTOConverter.class, ProductConfigurationDTOConverter.class})
public class ProductConfigurationDTOConverter
implements DTOConverter {
    @Reference
    private CPDefinitionInventoryService _cpDefinitionInventoryService;

    public String getContentType() {
        return ProductConfiguration.class.getSimpleName();
    }

    public ProductConfiguration toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryService.fetchCPDefinitionInventoryByCPDefinitionId(dtoConverterContext.getResourcePrimKey());
        if (cpDefinitionInventory == null) {
            return new ProductConfiguration();
        }
        return new ProductConfiguration(){
            {
                this.allowBackOrder = cpDefinitionInventory.isBackOrders();
                this.allowedOrderQuantities = ArrayUtil.toArray((int[])cpDefinitionInventory.getAllowedOrderQuantitiesArray());
                this.inventoryEngine = cpDefinitionInventory.getCPDefinitionInventoryEngine();
                this.maxOrderQuantity = cpDefinitionInventory.getMaxOrderQuantity();
                this.minOrderQuantity = cpDefinitionInventory.getMinOrderQuantity();
                this.multipleOrderQuantity = cpDefinitionInventory.getMultipleOrderQuantity();
            }
        };
    }
}

