/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductShippingConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductShippingConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductShippingConfigurationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-shipping-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductShippingConfigurationResource.class})
public class ProductShippingConfigurationResourceImpl
extends BaseProductShippingConfigurationResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public ProductShippingConfiguration getProductByExternalReferenceCodeShippingConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        DTOConverter productShippingConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductShippingConfiguration");
        return (ProductShippingConfiguration)productShippingConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public ProductShippingConfiguration getProductIdShippingConfiguration(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        DTOConverter productShippingConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductShippingConfiguration");
        return (ProductShippingConfiguration)productShippingConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Response patchProductByExternalReferenceCodeShippingConfiguration(String externalReferenceCode, ProductShippingConfiguration productShippingConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateProductShippingConfiguration(cpDefinition, productShippingConfiguration);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdShippingConfiguration(Long id, ProductShippingConfiguration productShippingConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._updateProductShippingConfiguration(cpDefinition, productShippingConfiguration);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    private ProductShippingConfiguration _updateProductShippingConfiguration(CPDefinition cpDefinition, ProductShippingConfiguration productShippingConfiguration) throws Exception {
        cpDefinition = ProductShippingConfigurationUtil.updateCPDefinitionShippingInfo(this._cpDefinitionService, productShippingConfiguration, cpDefinition, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        DTOConverter productShippingConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductShippingConfiguration");
        return (ProductShippingConfiguration)productShippingConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }
}

