/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.service.CPOptionCategoryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.internal.odata.entity.v1_0.OptionCategoryEntityModel;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionCategoryResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionCategoryResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/option-category.properties"}, scope=ServiceScope.PROTOTYPE, service={OptionCategoryResource.class})
public class OptionCategoryResourceImpl
extends BaseOptionCategoryResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new OptionCategoryEntityModel();
    @Reference
    private CPOptionCategoryService _cpOptionCategoryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;
    @Context
    private User _user;

    @Override
    public Response deleteOptionCategory(Long id) throws Exception {
        this._cpOptionCategoryService.deleteCPOptionCategory(id.longValue());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Page<OptionCategory> getOptionCategoriesPage(Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)filter, CPOptionCategory.class, (String)"", (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), document -> this._toOptionCategory(this._cpOptionCategoryService.getCPOptionCategory(GetterUtil.getLong((String)document.get("entryClassPK")))), (Sort[])sorts);
    }

    @Override
    public OptionCategory getOptionCategory(Long id) throws Exception {
        DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        return (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public Response patchOptionCategory(Long id, OptionCategory optionCategory) throws Exception {
        this._updateOptionCategory(id, optionCategory);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public OptionCategory postOptionCategory(OptionCategory optionCategory) throws Exception {
        DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        CPOptionCategory cpOptionCategory = null;
        if (optionCategory.getId() != null) {
            cpOptionCategory = this._cpOptionCategoryService.fetchCPOptionCategory(optionCategory.getId().longValue());
        }
        cpOptionCategory = cpOptionCategory == null ? this._addOptionCategory(optionCategory) : this._updateOptionCategory(optionCategory.getId(), optionCategory);
        return (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOptionCategory.getCPOptionCategoryId()));
    }

    private CPOptionCategory _addOptionCategory(OptionCategory optionCategory) throws Exception {
        return this._cpOptionCategoryService.addCPOptionCategory(LanguageUtils.getLocalizedMap((Map)optionCategory.getTitle()), LanguageUtils.getLocalizedMap((Map)optionCategory.getDescription()), GetterUtil.get((Object)optionCategory.getPriority(), (double)0.0), optionCategory.getKey(), this._serviceContextHelper.getServiceContext(this._user));
    }

    private OptionCategory _toOptionCategory(CPOptionCategory cpOptionCategory) throws Exception {
        DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        return (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOptionCategory.getCPOptionCategoryId()));
    }

    private CPOptionCategory _updateOptionCategory(Long id, OptionCategory optionCategory) throws PortalException {
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryService.getCPOptionCategory(id.longValue());
        return this._cpOptionCategoryService.updateCPOptionCategory(cpOptionCategory.getCPOptionCategoryId(), LanguageUtils.getLocalizedMap((Map)optionCategory.getTitle()), LanguageUtils.getLocalizedMap((Map)optionCategory.getDescription()), GetterUtil.get((Object)optionCategory.getPriority(), (double)cpOptionCategory.getPriority()), optionCategory.getKey());
    }
}

