/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionSpecificationOptionValueException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.commerce.product.service.CPSpecificationOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductSpecificationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSpecificationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-specification.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductSpecificationResource.class})
public class ProductSpecificationResourceImpl
extends BaseProductSpecificationResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(ProductSpecificationResourceImpl.class);
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private CPSpecificationOptionService _cpSpecificationOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    @NestedField(parentClass=Product.class, value="productSpecifications")
    public Page<ProductSpecification> getProductIdProductSpecificationsPage(@NestedFieldId(value="productId") Long id, Pagination pagination) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        List cpDefinitionSpecificationOptionValues = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValues(cpDefinition.getCPDefinitionId(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValuesCount(cpDefinition.getCPDefinitionId());
        return Page.of(this._toProductSpecifications(cpDefinitionSpecificationOptionValues), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public ProductSpecification postProductIdProductSpecification(Long id, ProductSpecification productSpecification) throws Exception {
        return this._upsertProductSpecification(id, productSpecification);
    }

    private List<ProductSpecification> _toProductSpecifications(List<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues) throws Exception {
        ArrayList<ProductSpecification> productSpecifications = new ArrayList<ProductSpecification>();
        DTOConverter productSpecificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionSpecificationOptionValue.class.getName());
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            productSpecifications.add((ProductSpecification)productSpecificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId())));
        }
        return productSpecifications;
    }

    private CPDefinitionSpecificationOptionValue _updateProductSpecification(Long id, ProductSpecification productSpecification) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(id.longValue());
        return ProductSpecificationUtil.updateCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, cpDefinitionSpecificationOptionValue, productSpecification, this._serviceContextHelper.getServiceContext());
    }

    private ProductSpecification _upsertProductSpecification(Long id, ProductSpecification productSpecification) throws Exception {
        try {
            CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._updateProductSpecification(productSpecification.getId(), productSpecification);
            DTOConverter productSpecificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionSpecificationOptionValue.class.getName());
            return (ProductSpecification)productSpecificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId()));
        }
        catch (NoSuchCPDefinitionSpecificationOptionValueException nscpdsove) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find productSpecification with ID: " + productSpecification.getId()));
            }
            CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = ProductSpecificationUtil.addCPDefinitionSpecificationOptionValue(this._cpDefinitionSpecificationOptionValueService, this._cpSpecificationOptionService, id, productSpecification, this._serviceContextHelper.getServiceContext());
            DTOConverter productSpecificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionSpecificationOptionValue.class.getName());
            return (ProductSpecification)productSpecificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId()));
        }
    }
}

