/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPDefinitionOptionRelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPDefinitionOptionRel"}, service={DTOConverter.class, ProductOptionDTOConverter.class})
public class ProductOptionDTOConverter
implements DTOConverter {
    @Reference
    private CPDefinitionOptionRelService _cpDefinitionOptionRelService;

    public String getContentType() {
        return ProductOption.class.getSimpleName();
    }

    public ProductOption toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelService.getCPDefinitionOptionRel(dtoConverterContext.getResourcePrimKey());
        final CPOption cpOption = cpDefinitionOptionRel.getCPOption();
        return new ProductOption(){
            {
                this.description = LanguageUtils.getLanguageIdMap((Map)cpDefinitionOptionRel.getDescriptionMap());
                this.facetable = cpDefinitionOptionRel.isFacetable();
                this.fieldType = ProductOption.FieldType.create((String)cpDefinitionOptionRel.getDDMFormFieldTypeName());
                this.id = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
                this.key = cpOption.getKey();
                this.name = LanguageUtils.getLanguageIdMap((Map)cpDefinitionOptionRel.getNameMap());
                this.optionId = cpOption.getCPOptionId();
                this.required = cpDefinitionOptionRel.isRequired();
                this.skuContributor = cpDefinitionOptionRel.isSkuContributor();
            }
        };
    }
}

