/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPOptionException;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.CPOptionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseOptionResourceImpl;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/option.properties"}, scope=ServiceScope.PROTOTYPE, service={OptionResource.class})
public class OptionResourceImpl
extends BaseOptionResourceImpl {
    @Reference
    private CPOptionService _cpOptionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public Response deleteOption(Long id) throws Exception {
        CPOption cpOption = this._cpOptionService.getCPOption(id.longValue());
        this._cpOptionService.deleteCPOption(cpOption.getCPOptionId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response deleteOptionByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find Option with externalReferenceCode: " + externalReferenceCode);
        }
        this._cpOptionService.deleteCPOption(cpOption.getCPOptionId());
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Option getOption(Long id) throws Exception {
        DTOConverter optionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOption.class.getName());
        return (Option)optionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), GetterUtil.getLong((Object)id)));
    }

    @Override
    public Option getOptionByExternalReferenceCode(String externalReferenceCode) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        DTOConverter optionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOption.class.getName());
        return (Option)optionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOption.getCPOptionId()));
    }

    @Override
    public Page<Option> getOptionsPage(Pagination pagination) throws Exception {
        BaseModelSearchResult cpOptionBaseModelSearchResult = this._cpOptionService.searchCPOptions(this.contextCompany.getCompanyId(), null, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int totalItems = cpOptionBaseModelSearchResult.getLength();
        return Page.of(this._toOptions(cpOptionBaseModelSearchResult.getBaseModels()), (Pagination)pagination, (long)totalItems);
    }

    @Override
    public Response patchOption(Long id, Option option) throws Exception {
        this._updateOption(this._cpOptionService.getCPOption(id.longValue()), option);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchOptionByExternalReferenceCode(String externalReferenceCode, Option option) throws Exception {
        CPOption cpOption = this._cpOptionService.fetchByExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpOption == null) {
            throw new NoSuchCPOptionException("Unable to find Option with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateOption(cpOption, option);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Option postOption(Option option) throws Exception {
        return this._upsertOption(option);
    }

    private List<Option> _toOptions(List<CPOption> cpOptions) throws Exception {
        ArrayList<Option> options = new ArrayList<Option>();
        DTOConverter optionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOption.class.getName());
        for (CPOption cpOption : cpOptions) {
            options.add((Option)optionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOption.getCPOptionId())));
        }
        return options;
    }

    private Option _updateOption(CPOption cpOption, Option option) throws Exception {
        Option.FieldType fieldType = option.getFieldType();
        cpOption = this._cpOptionService.updateCPOption(cpOption.getCPOptionId(), LanguageUtils.getLocalizedMap((Map)option.getName()), LanguageUtils.getLocalizedMap((Map)option.getDescription()), fieldType.getValue(), GetterUtil.get((Object)option.getFacetable(), (boolean)cpOption.isFacetable()), GetterUtil.get((Object)option.getRequired(), (boolean)cpOption.isRequired()), GetterUtil.get((Object)option.getSkuContributor(), (boolean)cpOption.isSkuContributor()), option.getKey(), this._serviceContextHelper.getServiceContext());
        DTOConverter optionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOption.class.getName());
        return (Option)optionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOption.getCPOptionId()));
    }

    private Option _upsertOption(Option option) throws Exception {
        Option.FieldType fieldType = option.getFieldType();
        CPOption cpOption = this._cpOptionService.upsertCPOption(LanguageUtils.getLocalizedMap((Map)option.getName()), LanguageUtils.getLocalizedMap((Map)option.getDescription()), fieldType.getValue(), GetterUtil.get((Object)option.getFacetable(), (boolean)false), GetterUtil.get((Object)option.getRequired(), (boolean)false), GetterUtil.get((Object)option.getSkuContributor(), (boolean)false), option.getKey(), option.getExternalReferenceCode(), this._serviceContextHelper.getServiceContext());
        DTOConverter optionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOption.class.getName());
        return (Option)optionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpOption.getCPOptionId()));
    }
}

