/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Sku;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPInstance"}, service={DTOConverter.class, SkuDTOConverter.class})
public class SkuDTOConverter
implements DTOConverter {
    @Reference
    private CPInstanceHelper _cpInstanceHelper;
    @Reference
    private CPInstanceService _cpInstanceService;

    public String getContentType() {
        return Sku.class.getSimpleName();
    }

    public Sku toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPInstance cpInstance = this._cpInstanceService.getCPInstance(dtoConverterContext.getResourcePrimKey());
        return new Sku(){
            {
                this.cost = cpInstance.getCost();
                this.depth = cpInstance.getDepth();
                this.displayDate = cpInstance.getDisplayDate();
                this.expirationDate = cpInstance.getExpirationDate();
                this.externalReferenceCode = cpInstance.getExternalReferenceCode();
                this.gtin = cpInstance.getGtin();
                this.height = cpInstance.getHeight();
                this.id = cpInstance.getCPInstanceId();
                this.manufacturerPartNumber = cpInstance.getManufacturerPartNumber();
                this.options = SkuDTOConverter.this._getOptions(cpInstance);
                this.price = cpInstance.getPrice();
                this.promoPrice = cpInstance.getPromoPrice();
                this.published = cpInstance.isPublished();
                this.purchasable = cpInstance.isPurchasable();
                this.sku = cpInstance.getSku();
                this.weight = cpInstance.getWeight();
                this.width = cpInstance.getWidth();
            }
        };
    }

    private Map<String, String> _getOptions(CPInstance cpInstance) throws PortalException {
        HashMap<String, String> options = new HashMap<String, String>();
        Map cpDefinitionOptionRelsMap = this._cpInstanceHelper.getCPDefinitionOptionRelsMap(cpInstance.getJson());
        for (Map.Entry entry : cpDefinitionOptionRelsMap.entrySet()) {
            CPDefinitionOptionRel cpDefinitionOptionRel = (CPDefinitionOptionRel)entry.getKey();
            List cpDefinitionOptionValueRels = (List)entry.getValue();
            for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                options.put(String.valueOf(cpDefinitionOptionRel.getCPDefinitionOptionRelId()), String.valueOf(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId()));
            }
        }
        return options;
    }
}

