/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.util.v1_0;

import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.internal.util.DateConfigUtil;
import com.liferay.headless.commerce.core.util.DateConfig;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class AttachmentUtil {
    private static final String _TEMP_FOLDER_NAME = AttachmentUtil.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AttachmentUtil.class);

    public static FileEntry addFileEntry(Attachment attachment, long groupId, long userId, UniqueFileNameProvider uniqueFileNameProvider) throws Exception {
        if (Validator.isNotNull((String)attachment.getAttachment())) {
            byte[] attachmentBytes = Base64.decode((String)attachment.getAttachment());
            File file = new File(_TEMP_FOLDER_NAME);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(attachmentBytes);
            }
            return AttachmentUtil._addFileEntry(groupId, userId, file, MimeTypesUtil.getContentType((File)file), uniqueFileNameProvider);
        }
        if (Validator.isNotNull((String)attachment.getSrc())) {
            URI uri = new URI(attachment.getSrc());
            File file = new File(uri);
            return AttachmentUtil._addFileEntry(groupId, userId, file, MimeTypesUtil.getContentType((File)file), uniqueFileNameProvider);
        }
        return null;
    }

    public static Map<Locale, String> getTitleMap(CPAttachmentFileEntry cpAttachmentFileEntry, Attachment attachment) throws PortalException {
        if (attachment.getTitle() != null) {
            return LanguageUtils.getLocalizedMap((Map)attachment.getTitle());
        }
        if (cpAttachmentFileEntry == null) {
            return null;
        }
        return cpAttachmentFileEntry.getTitleMap();
    }

    public static CPAttachmentFileEntry upsertCPAttachmentFileEntry(CPAttachmentFileEntryService cpAttachmentFileEntryService, UniqueFileNameProvider uniqueFileNameProvider, Attachment attachment, long classNameId, long classPK, int type, ServiceContext serviceContext) throws Exception {
        Calendar displayCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        if (attachment.getDisplayDate() != null) {
            displayCalendar = DateConfigUtil.convertDateToCalendar(attachment.getDisplayDate());
        }
        DateConfig displayDateConfig = new DateConfig(displayCalendar);
        Calendar expirationCalendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
        expirationCalendar.add(2, 1);
        if (attachment.getExpirationDate() != null) {
            expirationCalendar = DateConfigUtil.convertDateToCalendar(attachment.getExpirationDate());
        }
        DateConfig expirationDateConfig = new DateConfig(expirationCalendar);
        long fileEntryId = 0L;
        FileEntry fileEntry = AttachmentUtil.addFileEntry(attachment, serviceContext.getScopeGroupId(), serviceContext.getUserId(), uniqueFileNameProvider);
        if (fileEntry != null) {
            fileEntryId = fileEntry.getFileEntryId();
        }
        return cpAttachmentFileEntryService.upsertCPAttachmentFileEntry(classNameId, classPK, fileEntryId, displayDateConfig.getMonth(), displayDateConfig.getDay(), displayDateConfig.getYear(), displayDateConfig.getHour(), displayDateConfig.getMinute(), expirationDateConfig.getMonth(), expirationDateConfig.getDay(), expirationDateConfig.getYear(), expirationDateConfig.getHour(), expirationDateConfig.getMinute(), GetterUtil.get((Object)attachment.getNeverExpire(), (boolean)false), AttachmentUtil.getTitleMap(null, attachment), GetterUtil.getString((Object)attachment.getOptions()), GetterUtil.getDouble((Object)attachment.getPriority()), type, attachment.getExternalReferenceCode(), serviceContext);
    }

    private static FileEntry _addFileEntry(long groupId, long userId, File file, String contentType, UniqueFileNameProvider uniqueFileNameProvider) throws PortalException {
        String uniqueFileName = uniqueFileNameProvider.provide(file.getName(), curFileName -> AttachmentUtil._exists(groupId, userId, curFileName));
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FOLDER_NAME, (String)uniqueFileName, (File)file, (String)contentType);
    }

    private static boolean _exists(long groupId, long userId, String curFileName) {
        try {
            return TempFileEntryUtil.getTempFileEntry((long)groupId, (long)userId, (String)_TEMP_FOLDER_NAME, (String)curFileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

