/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductTaxConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductTaxConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductTaxConfigurationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-tax-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductTaxConfigurationResource.class})
public class ProductTaxConfigurationResourceImpl
extends BaseProductTaxConfigurationResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    @Override
    public ProductTaxConfiguration getProductByExternalReferenceCodeTaxConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        DTOConverter productTaxConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductTaxConfiguration");
        return (ProductTaxConfiguration)productTaxConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public ProductTaxConfiguration getProductIdTaxConfiguration(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        DTOConverter productTaxConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductTaxConfiguration");
        return (ProductTaxConfiguration)productTaxConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Response patchProductByExternalReferenceCodeTaxConfiguration(String externalReferenceCode, ProductTaxConfiguration productTaxConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateProductTaxConfiguration(cpDefinition, productTaxConfiguration);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdTaxConfiguration(Long id, ProductTaxConfiguration productTaxConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._updateProductTaxConfiguration(cpDefinition, productTaxConfiguration);
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    private ProductTaxConfiguration _updateProductTaxConfiguration(CPDefinition cpDefinition, ProductTaxConfiguration productTaxConfiguration) throws Exception {
        cpDefinition = ProductTaxConfigurationUtil.updateCPDefinitionTaxCategoryInfo(this._cpDefinitionService, productTaxConfiguration, cpDefinition);
        DTOConverter productTaxConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductTaxConfiguration");
        return (ProductTaxConfiguration)productTaxConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }
}

