/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPDefinitionSpecificationOptionValueService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.OptionCategory;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Specification;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue"}, service={DTOConverter.class, ProductSpecificationDTOConverter.class})
public class ProductSpecificationDTOConverter
implements DTOConverter {
    @Reference
    private CPDefinitionSpecificationOptionValueService _cpDefinitionSpecificationOptionValueService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public String getContentType() {
        return ProductSpecification.class.getSimpleName();
    }

    public ProductSpecification toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this._cpDefinitionSpecificationOptionValueService.getCPDefinitionSpecificationOptionValue(dtoConverterContext.getResourcePrimKey());
        final CPDefinition cpDefinition = cpDefinitionSpecificationOptionValue.getCPDefinition();
        final CPOptionCategory cpOptionCategory = cpDefinitionSpecificationOptionValue.getCPOptionCategory();
        final CPSpecificationOption cpSpecificationOption = cpDefinitionSpecificationOptionValue.getCPSpecificationOption();
        final DTOConverter optionCategoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPOptionCategory.class.getName());
        final DTOConverter productDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinition.class.getName());
        final DTOConverter specificationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPSpecificationOption.class.getName());
        return new ProductSpecification(){
            {
                this.id = cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId();
                this.optionCategory = (OptionCategory)optionCategoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpOptionCategory.getCPOptionCategoryId()));
                this.priority = cpDefinitionSpecificationOptionValue.getPriority();
                this.product = (Product)productDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpDefinition.getCPDefinitionId()));
                this.specification = (Specification)specificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpSpecificationOption.getCPSpecificationOptionId()));
                this.value = LanguageUtils.getLanguageIdMap((Map)cpDefinitionSpecificationOptionValue.getValueMap());
            }
        };
    }
}

