/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetTagService;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CPDefinitionLinkService;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Category;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductShippingConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductTaxConfiguration;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.RelatedProduct;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPDefinition"}, service={DTOConverter.class, ProductDTOConverter.class})
public class ProductDTOConverter
implements DTOConverter {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetTagService _assetTagService;
    @Reference
    private CPDefinitionLinkService _cpDefinitionLinkService;
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    public String getContentType() {
        return Product.class.getSimpleName();
    }

    public Product toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final CPDefinition cpDefinition = this._cpDefinitionService.getCPDefinition(dtoConverterContext.getResourcePrimKey());
        final CProduct cProduct = cpDefinition.getCProduct();
        final ExpandoBridge expandoBridge = cpDefinition.getExpandoBridge();
        final DTOConverter productConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionInventory.class.getName());
        final DTOConverter productShippingConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductShippingConfiguration");
        final DTOConverter productSubscriptionConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductSubscriptionConfiguration");
        final DTOConverter productTaxConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductTaxConfiguration");
        return new Product(){
            {
                this.active = !cpDefinition.isInactive();
                this.attachments = ProductDTOConverter.this._getAttachments(cpDefinition, 1, dtoConverterContext);
                this.catalogId = ProductDTOConverter.this._getCommerceCatalogId(cpDefinition);
                this.categories = ProductDTOConverter.this._getCategories(cpDefinition, dtoConverterContext);
                this.configuration = (ProductConfiguration)productConfigurationDTOConverter.toDTO(dtoConverterContext);
                this.description = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getDescriptionMap());
                this.expando = expandoBridge.getAttributes();
                this.externalReferenceCode = cProduct.getExternalReferenceCode();
                this.id = cpDefinition.getCPDefinitionId();
                this.images = ProductDTOConverter.this._getAttachments(cpDefinition, 0, dtoConverterContext);
                this.metaDescription = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaDescriptionMap());
                this.metaKeyword = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaKeywordsMap());
                this.metaTitle = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getMetaTitleMap());
                this.name = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getNameMap());
                this.options = ProductDTOConverter.this._getProductOptions(cpDefinition, dtoConverterContext);
                this.productId = cProduct.getCProductId();
                this.productType = cpDefinition.getProductTypeName();
                this.relatedProducts = ProductDTOConverter.this._getRelatedProducts(cpDefinition, dtoConverterContext);
                this.shippingConfiguration = (ProductShippingConfiguration)productShippingConfigurationDTOConverter.toDTO(dtoConverterContext);
                this.shortDescription = LanguageUtils.getLanguageIdMap((Map)cpDefinition.getShortDescriptionMap());
                this.subscriptionConfiguration = (ProductSubscriptionConfiguration)productSubscriptionConfigurationDTOConverter.toDTO(dtoConverterContext);
                this.taxConfiguration = (ProductTaxConfiguration)productTaxConfigurationDTOConverter.toDTO(dtoConverterContext);
                this.tags = ProductDTOConverter.this._getTags(cpDefinition);
            }
        };
    }

    private Attachment[] _getAttachments(CPDefinition cpDefinition, int type, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        DTOConverter attachmentDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPAttachmentFileEntry.class.getName());
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpDefinition.getCPAttachmentFileEntries(type, 0)) {
            attachments.add((Attachment)attachmentDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpAttachmentFileEntry.getCPAttachmentFileEntryId())));
        }
        Stream stream = attachments.stream();
        return (Attachment[])stream.toArray(Attachment[]::new);
    }

    private Category[] _getCategories(CPDefinition cpDefinition, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<Category> categories = new ArrayList<Category>();
        List assetCategories = this._assetCategoryService.getCategories(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        DTOConverter categoryDTOConverter = this._dtoConverterRegistry.getDTOConverter(AssetCategory.class.getName());
        for (AssetCategory assetCategory : assetCategories) {
            categories.add((Category)categoryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), assetCategory.getCategoryId())));
        }
        Stream stream = categories.stream();
        return (Category[])stream.toArray(Category[]::new);
    }

    private long _getCommerceCatalogId(CPDefinition cpDefinition) {
        CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
        if (commerceCatalog == null) {
            return 0L;
        }
        return commerceCatalog.getCommerceCatalogId();
    }

    private ProductOption[] _getProductOptions(CPDefinition cpDefinition, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<ProductOption> productOptions = new ArrayList<ProductOption>();
        DTOConverter productOptionDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionOptionRel.class.getName());
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinition.getCPDefinitionOptionRels()) {
            productOptions.add((ProductOption)productOptionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpDefinitionOptionRel.getCPDefinitionOptionRelId())));
        }
        Stream stream = productOptions.stream();
        return (ProductOption[])stream.toArray(ProductOption[]::new);
    }

    private RelatedProduct[] _getRelatedProducts(CPDefinition cpDefinition, DTOConverterContext dtoConverterContext) throws Exception {
        ArrayList<RelatedProduct> relatedProducts = new ArrayList<RelatedProduct>();
        DTOConverter relatedProductDTOConverter = this._dtoConverterRegistry.getDTOConverter(CPDefinitionLink.class.getName());
        List cpDefinitionLinks = this._cpDefinitionLinkService.getCPDefinitionLinks(cpDefinition.getCPDefinitionId(), -1, -1);
        for (CPDefinitionLink cpDefinitionLink : cpDefinitionLinks) {
            relatedProducts.add((RelatedProduct)relatedProductDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(dtoConverterContext.getLocale(), cpDefinitionLink.getCPDefinitionLinkId())));
        }
        Stream stream = relatedProducts.stream();
        return (RelatedProduct[])stream.toArray(RelatedProduct[]::new);
    }

    private String[] _getTags(CPDefinition cpDefinition) {
        List assetEntryAssetTags = this._assetTagService.getTags(cpDefinition.getModelClassName(), cpDefinition.getCPDefinitionId());
        Stream stream = assetEntryAssetTags.stream();
        return (String[])stream.map(AssetTagModel::getName).toArray(String[]::new);
    }
}

