/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.dto.v1_0.converter;

import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.service.CPAttachmentFileEntryService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Attachment;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.util.LanguageUtils;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.product.model.CPAttachmentFileEntry"}, service={AttachmentDTOConverter.class, DTOConverter.class})
public class AttachmentDTOConverter
implements DTOConverter {
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CPAttachmentFileEntryService _cpAttachmentFileEntryService;
    @Reference
    private File _file;
    @Reference
    private JSONFactory _jsonFactory;

    public String getContentType() {
        return Attachment.class.getSimpleName();
    }

    public Attachment toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final CPAttachmentFileEntry cpAttachmentFileEntry = this._cpAttachmentFileEntryService.getCPAttachmentFileEntry(dtoConverterContext.getResourcePrimKey());
        FileEntry fileEntry = cpAttachmentFileEntry.getFileEntry();
        final byte[] bytes = this._file.getBytes(fileEntry.getContentStream());
        return new Attachment(){
            {
                this.attachment = Base64.encode((byte[])bytes);
                this.displayDate = cpAttachmentFileEntry.getDisplayDate();
                this.expirationDate = cpAttachmentFileEntry.getExpirationDate();
                this.externalReferenceCode = cpAttachmentFileEntry.getExternalReferenceCode();
                this.id = cpAttachmentFileEntry.getCPAttachmentFileEntryId();
                this.options = AttachmentDTOConverter.this._getAttachmentOptions(cpAttachmentFileEntry);
                this.priority = cpAttachmentFileEntry.getPriority();
                this.src = AttachmentDTOConverter.this._commerceMediaResolver.getDownloadUrl(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
                this.title = LanguageUtils.getLanguageIdMap((Map)cpAttachmentFileEntry.getTitleMap());
                this.type = cpAttachmentFileEntry.getType();
            }
        };
    }

    private Map<String, String> _getAttachmentOptions(CPAttachmentFileEntry cpAttachmentFileEntry) throws JSONException {
        String json = cpAttachmentFileEntry.getJson();
        if (Validator.isNull((String)json)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject)element;
            if (!jsonObject.has("key")) continue;
            options.put(jsonObject.getString("key"), jsonObject.getString("value"));
        }
        return options;
    }
}

