/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSubscriptionConfiguration;
import com.liferay.headless.commerce.admin.catalog.internal.resource.v1_0.BaseProductSubscriptionConfigurationResourceImpl;
import com.liferay.headless.commerce.admin.catalog.internal.util.v1_0.ProductSubscriptionConfigurationUtil;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSubscriptionConfigurationResource;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverter;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterContext;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DTOConverterRegistry;
import com.liferay.headless.commerce.core.dto.v1_0.converter.DefaultDTOConverterContext;
import com.liferay.headless.commerce.core.util.ServiceContextHelper;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/product-subscription-configuration.properties"}, scope=ServiceScope.PROTOTYPE, service={ProductSubscriptionConfigurationResource.class})
public class ProductSubscriptionConfigurationResourceImpl
extends BaseProductSubscriptionConfigurationResourceImpl {
    @Reference
    private CPDefinitionService _cpDefinitionService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ServiceContextHelper _serviceContextHelper;

    @Override
    public ProductSubscriptionConfiguration getProductByExternalReferenceCodeSubscriptionConfiguration(String externalReferenceCode) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        DTOConverter productSubscriptionConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductSubscriptionConfiguration");
        return (ProductSubscriptionConfiguration)productSubscriptionConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public ProductSubscriptionConfiguration getProductIdSubscriptionConfiguration(Long id) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        DTOConverter productSubscriptionConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductSubscriptionConfiguration");
        return (ProductSubscriptionConfiguration)productSubscriptionConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }

    @Override
    public Response patchProductByExternalReferenceCodeSubscriptionConfiguration(String externalReferenceCode, ProductSubscriptionConfiguration productSubscriptionConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductExternalReferenceCode(this.contextCompany.getCompanyId(), externalReferenceCode);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with externalReferenceCode: " + externalReferenceCode);
        }
        this._updateProductSubscriptionConfiguration(cpDefinition, productSubscriptionConfiguration);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    @Override
    public Response patchProductIdSubscriptionConfiguration(Long id, ProductSubscriptionConfiguration productSubscriptionConfiguration) throws Exception {
        CPDefinition cpDefinition = this._cpDefinitionService.fetchCPDefinitionByCProductId(id.longValue());
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException("Unable to find Product with ID: " + id);
        }
        this._updateProductSubscriptionConfiguration(cpDefinition, productSubscriptionConfiguration);
        Response.ResponseBuilder responseBuilder = Response.noContent();
        return responseBuilder.build();
    }

    private ProductSubscriptionConfiguration _updateProductSubscriptionConfiguration(CPDefinition cpDefinition, ProductSubscriptionConfiguration productSubscriptionConfiguration) throws Exception {
        cpDefinition = ProductSubscriptionConfigurationUtil.updateCPDefinitionSubscriptionInfo(this._cpDefinitionService, productSubscriptionConfiguration, cpDefinition, this._serviceContextHelper.getServiceContext(cpDefinition.getGroupId()));
        DTOConverter productSubscriptionConfigurationDTOConverter = this._dtoConverterRegistry.getDTOConverter("ProductSubscriptionConfiguration");
        return (ProductSubscriptionConfiguration)productSubscriptionConfigurationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.getPreferredLocale(), cpDefinition.getCPDefinitionId()));
    }
}

