/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.term.model;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.base.BaseTable;

import java.sql.Clob;
import java.sql.Types;

/**
 * The table class for the &quot;CTermEntryLocalization&quot; database table.
 *
 * @author Luca Pellizzon
 * @see CTermEntryLocalization
 * @generated
 */
public class CTermEntryLocalizationTable
	extends BaseTable<CTermEntryLocalizationTable> {

	public static final CTermEntryLocalizationTable INSTANCE =
		new CTermEntryLocalizationTable();

	public final Column<CTermEntryLocalizationTable, Long> mvccVersion =
		createColumn(
			"mvccVersion", Long.class, Types.BIGINT, Column.FLAG_NULLITY);
	public final Column<CTermEntryLocalizationTable, Long>
		cTermEntryLocalizationId = createColumn(
			"cTermEntryLocalizationId", Long.class, Types.BIGINT,
			Column.FLAG_PRIMARY);
	public final Column<CTermEntryLocalizationTable, Long> companyId =
		createColumn(
			"companyId", Long.class, Types.BIGINT, Column.FLAG_DEFAULT);
	public final Column<CTermEntryLocalizationTable, Long> commerceTermEntryId =
		createColumn(
			"commerceTermEntryId", Long.class, Types.BIGINT,
			Column.FLAG_DEFAULT);
	public final Column<CTermEntryLocalizationTable, String> languageId =
		createColumn(
			"languageId", String.class, Types.VARCHAR, Column.FLAG_DEFAULT);
	public final Column<CTermEntryLocalizationTable, Clob> description =
		createColumn(
			"description", Clob.class, Types.CLOB, Column.FLAG_DEFAULT);
	public final Column<CTermEntryLocalizationTable, String> label =
		createColumn("label", String.class, Types.VARCHAR, Column.FLAG_DEFAULT);

	private CTermEntryLocalizationTable() {
		super("CTermEntryLocalization", CTermEntryLocalizationTable::new);
	}

}