/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.site.initializer.extender;

import com.liferay.account.settings.AccountEntryGroupSettings;
import com.liferay.commerce.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.helper.CommerceRoleHelper;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionCategoriesImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceInventoryWarehousesImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateLocalService;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.commerce.util.AccountEntryAllowedTypesUtil;
import com.liferay.headless.commerce.admin.account.dto.v1_0.AdminAccountGroup;
import com.liferay.headless.commerce.admin.account.resource.v1_0.AdminAccountGroupResource;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ChannelResource;
import com.liferay.headless.commerce.admin.order.dto.v1_0.OrderType;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderTypeResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.settings.FallbackKeysSettingsUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.site.initializer.extender.CommerceSiteInitializer;
import com.liferay.site.initializer.extender.SiteInitializerUtil;
import jakarta.servlet.ServletContext;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceSiteInitializer.class})
public class CommerceSiteInitializerImpl
implements CommerceSiteInitializer {
    private static final Log _log = LogFactoryUtil.getLog(CommerceSiteInitializerImpl.class);
    @Reference
    private AccountEntryGroupSettings _accountEntryGroupSettings;
    @Reference
    private AdminAccountGroupResource.Factory _adminAccountGroupResourceFactory;
    @Reference
    private CatalogResource.Factory _catalogResourceFactory;
    @Reference
    private ChannelResource.Factory _channelResourceFactory;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceInventoryWarehousesImporter _commerceInventoryWarehousesImporter;
    @Reference
    private CommerceNotificationTemplateLocalService _commerceNotificationTemplateLocalService;
    @Reference
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CommerceRoleHelper _commerceRoleHelper;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionCategoriesImporter _cpOptionCategoriesImporter;
    @Reference
    private CPOptionLocalService _cpOptionLocalService;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private OrderTypeResource.Factory _orderTypeResourceFactory;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference
    private ProductOptionResource.Factory _productOptionResourceFactory;
    @Reference
    private ProductSpecificationResource.Factory _productSpecificationResourceFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;

    public void addAccountGroups(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/account-groups.json", (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        AdminAccountGroupResource.Builder builder = this._adminAccountGroupResourceFactory.create();
        AdminAccountGroupResource adminAccountGroupResource = builder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            AdminAccountGroup accountGroup = AdminAccountGroup.toDTO((String)String.valueOf(jsonArray.getJSONObject(i)));
            if (accountGroup == null) {
                _log.error((Object)("Unable to transform account group from JSON: " + json));
                continue;
            }
            adminAccountGroupResource.postAccountGroup(accountGroup);
        }
    }

    public void addCPDefinitions(Bundle bundle, ServiceContext serviceContext, ServletContext servletContext, Map<String, String> stringUtilReplaceValues) throws Exception {
        Channel channel = this._addOrUpdateCommerceChannel(serviceContext, servletContext);
        if (channel == null) {
            return;
        }
        this._addOrUpdateCommerceCatalogs(bundle, channel, this._addCommerceInventoryWarehouses(serviceContext, servletContext), serviceContext, servletContext, stringUtilReplaceValues);
        this._addCommerceNotificationTemplates(bundle, channel.getId(), serviceContext, servletContext, stringUtilReplaceValues);
        this._addOrUpdateCommerceOrderTypes(serviceContext, servletContext);
    }

    public void addPortletSettings(ClassLoader classLoader, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/portlet-settings.json";
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(this._jsonFactory.createJSONArray(json), classLoader, "/site-initializer/portlet-settings/", serviceContext.getScopeGroupId(), group.getGroupId(), serviceContext.getUserId());
    }

    public long getCommerceChannelGroupId(long siteGroupId) {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(siteGroupId);
        return commerceChannel.getGroupId();
    }

    public String getCommerceOrderClassName() {
        return CommerceOrder.class.getName();
    }

    private void _addCommerceChannelConfiguration(Channel channel, String resourcePath, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        CommerceChannel commerceChannel = this._commerceChannelService.getCommerceChannel(channel.getId().longValue());
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        Map map1 = jsonObject.toMap();
        for (Map.Entry entry1 : map1.entrySet()) {
            Settings settings = FallbackKeysSettingsUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), (String)entry1.getKey()));
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            Map map2 = (Map)entry1.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                modifiableSettings.setValue((String)entry2.getKey(), String.valueOf(entry2.getValue()));
            }
            modifiableSettings.store();
        }
        this._accountEntryGroupSettings.setAllowedTypes(commerceChannel.getSiteGroupId(), this._getAllowedTypes(commerceChannel.getGroupId()));
    }

    private List<CommerceInventoryWarehouse> _addCommerceInventoryWarehouses(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        return this._commerceInventoryWarehousesImporter.importCommerceInventoryWarehouses(this._jsonFactory.createJSONArray(SiteInitializerUtil.read((String)"/site-initializer/commerce-inventory-warehouses.json", (ServletContext)servletContext)), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addCommerceNotificationTemplate(Bundle bundle, long commerceChannelId, String resourcePath, ServiceContext serviceContext, ServletContext servletContext, Map<String, String> stringUtilReplaceValues) throws Exception {
        String json = SiteInitializerUtil.read((String)(resourcePath + "commerce-notification-template.json"), (ServletContext)servletContext);
        if (Validator.isNull((String)json)) {
            return;
        }
        JSONObject commerceNotificationTemplateJSONObject = this._jsonFactory.createJSONObject(json);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        JSONObject bodyJSONObject = this._jsonFactory.createJSONObject();
        Enumeration enumeration = bundle.findEntries(resourcePath, "*.html", false);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                bodyJSONObject.put(FileUtil.getShortFileName((String)FileUtil.stripExtension((String)url.getPath())), StringUtil.replace((String)URLUtil.toString((URL)url), (String)"[$", (String)"$]", stringUtilReplaceValues));
            }
        }
        this._commerceNotificationTemplateLocalService.addCommerceNotificationTemplate(serviceContext.getUserId(), commerceChannel.getGroupId(), commerceNotificationTemplateJSONObject.getString("name"), commerceNotificationTemplateJSONObject.getString("description"), commerceNotificationTemplateJSONObject.getString("from"), SiteInitializerUtil.toMap((String)commerceNotificationTemplateJSONObject.getString("fromName")), commerceNotificationTemplateJSONObject.getString("to"), commerceNotificationTemplateJSONObject.getString("cc"), commerceNotificationTemplateJSONObject.getString("bcc"), StringUtil.replace((String)commerceNotificationTemplateJSONObject.getString("type"), (String)"[$", (String)"$]", stringUtilReplaceValues), commerceNotificationTemplateJSONObject.getBoolean("enabled"), SiteInitializerUtil.toMap((String)commerceNotificationTemplateJSONObject.getString("subject")), SiteInitializerUtil.toMap((String)bodyJSONObject.toString()), serviceContext);
    }

    private void _addCommerceNotificationTemplates(Bundle bundle, long commerceChannelId, ServiceContext serviceContext, ServletContext servletContext, Map<String, String> stringUtilReplaceValues) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/site-initializer/commerce-notification-templates");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            this._addCommerceNotificationTemplate(bundle, commerceChannelId, resourcePath, serviceContext, servletContext, stringUtilReplaceValues);
        }
    }

    private void _addCommerceProductSpecifications(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        ProductSpecificationResource.Builder productSpecificationResourceBuilder = this._productSpecificationResourceFactory.create();
        ProductSpecificationResource productSpecificationResource = productSpecificationResourceBuilder.user(serviceContext.fetchUser()).build();
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            final JSONObject jsonObject = jsonArray.getJSONObject(i);
            final CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(jsonObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId());
            if (cpDefinition == null) continue;
            ProductSpecification productSpecification = new ProductSpecification(){
                {
                    this.setProductId(() -> ((CPDefinition)cpDefinition).getCProductId());
                    this.setSpecificationKey(() -> jsonObject.getString("key"));
                    this.setValue(() -> JSONUtil.toStringMap((JSONObject)jsonObject.getJSONObject("productSpecificationValue")));
                }
            };
            productSpecificationResource.postProductIdProductSpecification(Long.valueOf(cpDefinition.getCProductId()), productSpecification);
        }
    }

    private void _addCPDefinitions(String assetVocabularyName, Bundle bundle, Catalog catalog, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, String resourcePath, ServiceContext serviceContext, ServletContext servletContext, Map<String, String> stringUtilReplaceValues) throws Exception {
        Group commerceCatalogGroup = this._commerceCatalogLocalService.getCommerceCatalogGroup(catalog.getId().longValue());
        List existingCPDefinitions = this._cpDefinitionLocalService.getCPDefinitions(commerceCatalogGroup.getGroupId(), -1, -1, -1);
        for (CPDefinition cpDefinition : existingCPDefinitions) {
            CProduct cProduct = cpDefinition.getCProduct();
            stringUtilReplaceValues.put("CP_DEFINITION_ID:" + cProduct.getExternalReferenceCode(), String.valueOf(cpDefinition.getCPDefinitionId()));
        }
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List cpDefinitions = this._cpDefinitionsImporter.importCPDefinitions(this._jsonFactory.createJSONArray(json), assetVocabularyName, commerceCatalogGroup.getGroupId(), channel.getId().longValue(), ListUtil.toLongArray(commerceInventoryWarehouses, (Accessor)CommerceInventoryWarehouse.COMMERCE_INVENTORY_WAREHOUSE_ID_ACCESSOR), bundleWiring.getClassLoader(), StringUtil.replace((String)resourcePath, (String)".json", (String)"/"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (ListUtil.isEmpty((List)cpDefinitions)) {
            return;
        }
        for (CPDefinition cpDefinition : cpDefinitions) {
            CProduct cProduct = cpDefinition.getCProduct();
            stringUtilReplaceValues.put("CP_DEFINITION_ID:" + cProduct.getExternalReferenceCode(), String.valueOf(cpDefinition.getCPDefinitionId()));
            List cpInstances = cpDefinition.getCPInstances();
            if (ListUtil.isEmpty((List)cpInstances)) continue;
            for (CPInstance cpInstance : cpInstances) {
                this._addOrUpdateCommercePriceEntries(cpDefinition, cpInstance, serviceContext);
            }
        }
    }

    private void _addCPInstanceSubscriptions(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        ProductOptionResource.Builder productOptionResourceBuilder = this._productOptionResourceFactory.create();
        ProductOptionResource productOptionResource = productOptionResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPDefinition cpDefinition;
            JSONObject subscriptionPropertiesJSONObject = jsonArray.getJSONObject(i);
            final CPOption cpOption = this._cpOptionLocalService.fetchCPOption(serviceContext.getCompanyId(), subscriptionPropertiesJSONObject.getString("optionKey"));
            if (cpOption == null || (cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(subscriptionPropertiesJSONObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId())) == null) continue;
            productOptionResource.postProductIdProductOptionsPage(Long.valueOf(cpDefinition.getCProductId()), new ProductOption[]{new ProductOption(){
                {
                    this.setFacetable(() -> ((CPOption)cpOption).isFacetable());
                    this.setFieldType(() -> ((CPOption)cpOption).getCommerceOptionTypeKey());
                    this.setKey(() -> ((CPOption)cpOption).getKey());
                    this.setName(() -> LocalizedMapUtil.getI18nMap((Map)cpOption.getNameMap()));
                    this.setOptionId(() -> ((CPOption)cpOption).getCPOptionId());
                    this.setRequired(() -> ((CPOption)cpOption).isRequired());
                    this.setSkuContributor(() -> ((CPOption)cpOption).isSkuContributor());
                }
            }});
            this._cpInstanceLocalService.buildCPInstances(cpDefinition.getCPDefinitionId(), serviceContext);
            JSONArray cpInstancePropertiesJSONArray = subscriptionPropertiesJSONObject.getJSONArray("cpInstanceProperties");
            if (cpInstancePropertiesJSONArray == null) continue;
            for (int j = 0; j < cpInstancePropertiesJSONArray.length(); ++j) {
                JSONObject cpInstancePropertiesJSONObject = cpInstancePropertiesJSONArray.getJSONObject(j);
                this._updateCPInstanceProperties(cpDefinition, cpInstancePropertiesJSONObject, serviceContext);
            }
            this._addOrUpdateCommercePriceEntries(cpDefinition, this._cpInstanceLocalService.fetchCPInstanceByExternalReferenceCode(subscriptionPropertiesJSONObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId()), serviceContext);
        }
    }

    private void _addCPOptions(Catalog catalog, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        Group commerceCatalogGroup = this._commerceCatalogLocalService.getCommerceCatalogGroup(catalog.getId().longValue());
        this._cpOptionsImporter.importCPOptions(this._jsonFactory.createJSONArray(json), commerceCatalogGroup.getGroupId(), serviceContext.getUserId());
    }

    private void _addCPSpecificationOptions(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addDefaultCPDisplayLayout(Channel channel, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), jsonObject.getBoolean("privateLayout"), jsonObject.getString("friendlyURL"));
        if (layout == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to create a default product commerce product display layout from JSON: " + json));
            }
            return;
        }
        CommerceChannel commerceChannel = this._commerceChannelService.getCommerceChannel(channel.getId().longValue());
        Settings settings = FallbackKeysSettingsUtil.getSettings((SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.product.display.layout"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("productLayoutUuid", layout.getUuid());
        modifiableSettings.store();
    }

    private void _addModelResourcePermissions(String className, String primKey, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._resourcePermissionLocalService.addModelResourcePermissions(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), serviceContext.getUserId(), className, primKey, ModelPermissionsFactory.create((Map)HashMapBuilder.put((Object)jsonObject.getString("roleName"), (Object)ArrayUtil.toStringArray((JSONArray)jsonObject.getJSONArray("actionIds"))).build(), null));
        }
    }

    private void _addOrUpdateCommerceCatalogs(Bundle bundle, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext, ServletContext servletContext, Map<String, String> stringUtilReplaceValues) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/site-initializer/commerce-catalogs");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        CatalogResource.Builder builder = this._catalogResourceFactory.create();
        CatalogResource catalogResource = builder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(".options.json") || resourcePath.endsWith(".products.json") || resourcePath.endsWith(".products.specifications.json") || resourcePath.endsWith(".products.subscriptions.properties.json") || resourcePath.endsWith("commerce-option-categories.json") || !resourcePath.endsWith(".json")) continue;
            String json = SiteInitializerUtil.replace((String)SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext), (ServiceContext)serviceContext);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            String assetVocabularyName = jsonObject.getString("assetVocabularyName");
            jsonObject.remove("assetVocabularyName");
            Catalog catalog = Catalog.toDTO((String)String.valueOf(jsonObject));
            if (catalog == null) {
                _log.error((Object)("Unable to transform commerce catalog from JSON: " + json));
                continue;
            }
            catalog = catalogResource.postCatalog(catalog);
            this._addCPOptions(catalog, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".options.json"), serviceContext, servletContext);
            this._addOrUpdateCPOptionCategories(serviceContext, servletContext);
            this._addCPSpecificationOptions(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".specification.options.json"), serviceContext, servletContext);
            this._addCPDefinitions(assetVocabularyName, bundle, catalog, channel, commerceInventoryWarehouses, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.json"), serviceContext, servletContext, stringUtilReplaceValues);
            this._addCommerceProductSpecifications(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.specifications.json"), serviceContext, servletContext);
            this._addCPInstanceSubscriptions(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.subscriptions.properties.json"), serviceContext, servletContext);
        }
    }

    private Channel _addOrUpdateCommerceChannel(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-channel.json";
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return null;
        }
        ChannelResource.Builder channelResourceBuilder = this._channelResourceFactory.create();
        ChannelResource channelResource = channelResourceBuilder.user(serviceContext.fetchUser()).build();
        json = SiteInitializerUtil.replace((String)json, (ServiceContext)serviceContext);
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        jsonObject.put("siteGroupId", serviceContext.getScopeGroupId());
        Channel channel = Channel.toDTO((String)jsonObject.toString());
        if (channel == null) {
            _log.error((Object)("Unable to transform commerce channel from JSON: " + json));
            return null;
        }
        Page channelsPage = channelResource.getChannelsPage(null, channelResource.toFilter(StringBundler.concat((Object[])new Object[]{"siteGroupId eq '", serviceContext.getScopeGroupId(), "'"})), null, null);
        Channel existingChannel = (Channel)channelsPage.fetchFirstItem();
        channel = existingChannel == null ? channelResource.postChannel(channel) : channelResource.putChannel(existingChannel.getId(), channel);
        this._addCommerceChannelConfiguration(channel, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".config.json"), servletContext);
        this._addDefaultCPDisplayLayout(channel, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".default-cp-display-layout.json"), serviceContext, servletContext);
        this._addModelResourcePermissions(CommerceChannel.class.getName(), String.valueOf(channel.getId()), StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".model-resource-permissions.json"), serviceContext, servletContext);
        this._commerceRoleHelper.checkCommerceAccountRoles(serviceContext);
        this._commerceCurrencyLocalService.importDefaultValues(true, serviceContext);
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        return channel;
    }

    private void _addOrUpdateCommerceOrderTypes(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-order-types.json";
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        OrderTypeResource.Builder builder = this._orderTypeResourceFactory.create();
        OrderTypeResource orderTypeResource = builder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            OrderType orderType = OrderType.toDTO((String)String.valueOf(jsonArray.getJSONObject(i)));
            if (orderType == null) {
                _log.error((Object)("Unable to transform commerce order type from JSON: " + json));
                continue;
            }
            CommerceOrderType serviceBuilderCommerceOrderType = this._commerceOrderTypeLocalService.fetchCommerceOrderTypeByExternalReferenceCode(orderType.getExternalReferenceCode(), serviceContext.getCompanyId());
            if (serviceBuilderCommerceOrderType == null) {
                orderTypeResource.postOrderType(orderType);
                continue;
            }
            orderTypeResource.patchOrderTypeByExternalReferenceCode(serviceBuilderCommerceOrderType.getExternalReferenceCode(), orderType);
        }
    }

    private void _addOrUpdateCommercePriceEntries(CPDefinition cpDefinition, CPInstance cpInstance, ServiceContext serviceContext) throws Exception {
        this._addOrUpdateCommercePriceEntry(cpDefinition, cpInstance, serviceContext, "price-list");
        this._addOrUpdateCommercePriceEntry(cpDefinition, cpInstance, serviceContext, "promotion");
    }

    private void _addOrUpdateCommercePriceEntry(CPDefinition cpDefinition, CPInstance cpInstance, ServiceContext serviceContext, String type) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCatalogBaseCommercePriceListByType(cpInstance.getGroupId(), type);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid(), "");
        BigDecimal price = cpInstance.getPrice();
        if ("promotion".equals(commercePriceList.getType())) {
            price = cpInstance.getPromoPrice();
        }
        serviceContext.setWorkflowAction(1);
        if (commercePriceEntry == null) {
            this._commercePriceEntryLocalService.addCommercePriceEntry(null, cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceList.getCommercePriceListId(), price, false, BigDecimal.ZERO, null, serviceContext);
        } else {
            this._commercePriceEntryLocalService.updatePricingInfo(commercePriceEntry.getCommercePriceEntryId(), commercePriceEntry.isBulkPricing(), price, commercePriceEntry.isPriceOnApplication(), BigDecimal.ZERO, null, serviceContext);
        }
    }

    private void _addOrUpdateCPOptionCategories(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-option-categories.json";
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._cpOptionCategoriesImporter.importCPOptionCategories(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private String[] _getAllowedTypes(long commerceChannelGroupId) throws Exception {
        CommerceAccountGroupServiceConfiguration commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannelGroupId, "com.liferay.commerce.account"));
        return AccountEntryAllowedTypesUtil.getAllowedTypes((int)commerceAccountGroupServiceConfiguration.commerceSiteType());
    }

    private void _updateCPInstanceProperties(CPDefinition cpDefinition, JSONObject cpInstancePropertiesJSONObject, ServiceContext serviceContext) throws Exception {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpDefinition.getCPDefinitionId(), cpInstancePropertiesJSONObject.getString("cpInstanceSku"));
        if (cpInstance == null) {
            return;
        }
        String propertyType = cpInstancePropertiesJSONObject.getString("propertyType");
        if (StringUtil.equals((String)propertyType, (String)"CREATE_SUBSCRIPTION")) {
            JSONObject subscriptionTypeSettingsJSONObject = cpInstancePropertiesJSONObject.getJSONObject("subscriptionTypeSettings");
            this._cpInstanceLocalService.updateSubscriptionInfo(cpInstance.getCPInstanceId(), cpInstancePropertiesJSONObject.getBoolean("overrideSubscriptionInfo"), cpInstancePropertiesJSONObject.getBoolean("subscriptionEnabled"), cpInstancePropertiesJSONObject.getInt("subscriptionLength"), cpInstancePropertiesJSONObject.getString("subscriptionType"), UnicodePropertiesBuilder.create((Map)JSONUtil.toStringMap((JSONObject)subscriptionTypeSettingsJSONObject), (boolean)true).build(), cpInstancePropertiesJSONObject.getLong("maxSubscriptionCycles"), cpInstancePropertiesJSONObject.getBoolean("deliverySubscriptionEnabled"), cpInstancePropertiesJSONObject.getInt("deliverySubscriptionLength"), cpInstancePropertiesJSONObject.getString("deliverySubscriptionType"), new UnicodeProperties(), cpInstancePropertiesJSONObject.getLong("deliveryMaxSubscriptionCycles"));
        } else if (StringUtil.equals((String)propertyType, (String)"UPDATE_PRICE")) {
            cpInstance.setPrice(BigDecimal.valueOf(cpInstancePropertiesJSONObject.getLong("skuPrice")));
            cpInstance.setPromoPrice(BigDecimal.valueOf(cpInstancePropertiesJSONObject.getLong("skuPromoPrice")));
            cpInstance = this._cpInstanceLocalService.updateCPInstance(cpInstance);
        }
        this._addOrUpdateCommercePriceEntries(cpDefinition, cpInstance, serviceContext);
    }
}

