/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.pricing.service;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.util.List;
import java.util.Map;

/**
 * Provides the remote service utility for CommercePricingClass. This utility wraps
 * <code>com.liferay.commerce.pricing.service.impl.CommercePricingClassServiceImpl</code> and is an
 * access point for service operations in application layer code running on a
 * remote server. Methods of this service are expected to have security checks
 * based on the propagated JAAS credentials because this service can be
 * accessed remotely.
 *
 * @author Riccardo Alberti
 * @see CommercePricingClassService
 * @generated
 */
public class CommercePricingClassServiceUtil {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Add custom service methods to <code>com.liferay.commerce.pricing.service.impl.CommercePricingClassServiceImpl</code> and rerun ServiceBuilder to regenerate this class.
	 */
	public static CommercePricingClass addCommercePricingClass(
			long userId, Map<java.util.Locale, String> titleMap,
			Map<java.util.Locale, String> descriptionMap,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws PortalException {

		return getService().addCommercePricingClass(
			userId, titleMap, descriptionMap, serviceContext);
	}

	public static CommercePricingClass addCommercePricingClass(
			long userId, Map<java.util.Locale, String> titleMap,
			Map<java.util.Locale, String> descriptionMap,
			String externalReferenceCode,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws PortalException {

		return getService().addCommercePricingClass(
			userId, titleMap, descriptionMap, externalReferenceCode,
			serviceContext);
	}

	public static CommercePricingClass deleteCommercePricingClass(
			long commercePricingClassId)
		throws PortalException {

		return getService().deleteCommercePricingClass(commercePricingClassId);
	}

	public static CommercePricingClass fetchByExternalReferenceCode(
			long companyId, String externalReferenceCode)
		throws PortalException {

		return getService().fetchByExternalReferenceCode(
			companyId, externalReferenceCode);
	}

	public static CommercePricingClass fetchCommercePricingClass(
			long commercePricingClassId)
		throws PortalException {

		return getService().fetchCommercePricingClass(commercePricingClassId);
	}

	public static CommercePricingClass getCommercePricingClass(
			long commercePricingClassId)
		throws PortalException {

		return getService().getCommercePricingClass(commercePricingClassId);
	}

	public static int getCommercePricingClassCountByCPDefinitionId(
			long cpDefinitionId, String title)
		throws com.liferay.portal.kernel.security.auth.PrincipalException {

		return getService().getCommercePricingClassCountByCPDefinitionId(
			cpDefinitionId, title);
	}

	public static List<CommercePricingClass> getCommercePricingClasses(
			long companyId, int start, int end,
			OrderByComparator<CommercePricingClass> orderByComparator)
		throws PortalException {

		return getService().getCommercePricingClasses(
			companyId, start, end, orderByComparator);
	}

	public static int getCommercePricingClassesCount(long companyId)
		throws PortalException {

		return getService().getCommercePricingClassesCount(companyId);
	}

	public static int getCommercePricingClassesCount(
			long cpDefinitionId, String title)
		throws com.liferay.portal.kernel.security.auth.PrincipalException {

		return getService().getCommercePricingClassesCount(
			cpDefinitionId, title);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	public static String getOSGiServiceIdentifier() {
		return getService().getOSGiServiceIdentifier();
	}

	public static com.liferay.portal.kernel.search.BaseModelSearchResult
		<CommercePricingClass> searchCommercePricingClasses(
				long companyId, String keywords, int start, int end,
				com.liferay.portal.kernel.search.Sort sort)
			throws PortalException {

		return getService().searchCommercePricingClasses(
			companyId, keywords, start, end, sort);
	}

	public static List<CommercePricingClass>
			searchCommercePricingClassesByCPDefinitionId(
				long cpDefinitionId, String title, int start, int end)
		throws com.liferay.portal.kernel.security.auth.PrincipalException {

		return getService().searchCommercePricingClassesByCPDefinitionId(
			cpDefinitionId, title, start, end);
	}

	public static CommercePricingClass updateCommercePricingClass(
			long commercePricingClassId, long userId,
			Map<java.util.Locale, String> titleMap,
			Map<java.util.Locale, String> descriptionMap,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws PortalException {

		return getService().updateCommercePricingClass(
			commercePricingClassId, userId, titleMap, descriptionMap,
			serviceContext);
	}

	public static CommercePricingClass
			updateCommercePricingClassExternalReferenceCode(
				long commercePricingClassId, String externalReferenceCode)
		throws PortalException {

		return getService().updateCommercePricingClassExternalReferenceCode(
			commercePricingClassId, externalReferenceCode);
	}

	public static CommercePricingClass upsertCommercePricingClass(
			long commercePricingClassId, long userId,
			Map<java.util.Locale, String> titleMap,
			Map<java.util.Locale, String> descriptionMap,
			String externalReferenceCode,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws PortalException {

		return getService().upsertCommercePricingClass(
			commercePricingClassId, userId, titleMap, descriptionMap,
			externalReferenceCode, serviceContext);
	}

	public static CommercePricingClassService getService() {
		return _service;
	}

	private static volatile CommercePricingClassService _service;

}