/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.pricing.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the CommercePricingClassCPDefinitionRel service. Represents a row in the &quot;CPricingClassCPDefinitionRel&quot; database table, with each column mapped to a property of this class.
 *
 * @author Riccardo Alberti
 * @see CommercePricingClassCPDefinitionRelModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.commerce.pricing.model.impl.CommercePricingClassCPDefinitionRelImpl"
)
@ProviderType
public interface CommercePricingClassCPDefinitionRel
	extends CommercePricingClassCPDefinitionRelModel, PersistedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.commerce.pricing.model.impl.CommercePricingClassCPDefinitionRelImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<CommercePricingClassCPDefinitionRel, Long>
		COMMERCE_PRICING_CLASS_CP_DEFINITION_REL_ID_ACCESSOR =
			new Accessor<CommercePricingClassCPDefinitionRel, Long>() {

				@Override
				public Long get(
					CommercePricingClassCPDefinitionRel
						commercePricingClassCPDefinitionRel) {

					return commercePricingClassCPDefinitionRel.
						getCommercePricingClassCPDefinitionRelId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<CommercePricingClassCPDefinitionRel>
					getTypeClass() {

					return CommercePricingClassCPDefinitionRel.class;
				}

			};

	public CommercePricingClass getCommercePricingClass()
		throws com.liferay.portal.kernel.exception.PortalException;

}