/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.pricing.constants;

/**
 * @author Riccardo Alberti
 * @author Alessio Antonio Rendina
 */
public class CommercePricingConstants {

	public static final String DISCOUNT_ADDITION_METHOD = "addition";

	public static final String DISCOUNT_CHAIN_METHOD = "chain";

	public static final String ORDER_BY_HIERARCHY = "hierarchy";

	public static final String ORDER_BY_LOWEST_ENTRY = "lowest";

	public static final String SERVICE_NAME =
		"com.liferay.commerce.pricing.service.name";

	/**
	 * @deprecated As of Athanasius (7.3.x)
	 */
	@Deprecated
	public static final int TAX_EXCLUDED_FROM_FINAL_PRICE = 1;

	public static final String TAX_EXCLUDED_FROM_PRICE = "tax-excluded";

	/**
	 * @deprecated As of Athanasius (7.3.x)
	 */
	@Deprecated
	public static final int TAX_INCLUDED_IN_FINAL_PRICE = 0;

	public static final String TAX_INCLUDED_IN_PRICE = "tax-included";

	public static final String VERSION_1_0 = "v1.0";

	public static final String VERSION_2_0 = "v2.0";

}