/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.pricing.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.commerce.pricing.constants.CommercePricingConstants;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Riccardo Alberti
 */
@ExtendedObjectClassDefinition(
	category = "pricing", scope = ExtendedObjectClassDefinition.Scope.SYSTEM
)
@Meta.OCD(
	id = "com.liferay.commerce.pricing.configuration.CommercePricingConfiguration",
	localization = "content/Language",
	name = "commerce-pricing-configuration-name"
)
public interface CommercePricingConfiguration {

	@Meta.AD(
		deflt = CommercePricingConstants.VERSION_2_0,
		name = "pricing-calculation-key", required = false
	)
	public String commercePricingCalculationKey();

	@Meta.AD(
		deflt = CommercePricingConstants.ORDER_BY_HIERARCHY,
		name = "price-list-discovery-method", required = false
	)
	public String commercePriceListDiscovery();

	@Meta.AD(
		deflt = CommercePricingConstants.ORDER_BY_HIERARCHY,
		name = "promotion-discovery-method", required = false
	)
	public String commercePromotionDiscovery();

	/**
	 * @deprecated As of Athanasius (7.3.x)
	 */
	@Deprecated
	@Meta.AD(
		deflt = "" + CommercePricingConstants.TAX_INCLUDED_IN_FINAL_PRICE,
		name = "tax-display",
		optionLabels = {
			"tax-included-in-final-price", "tax-excluded-from-final-price"
		},
		optionValues = {"0", "1"}, required = false
	)
	public int commerceDisplayTax();

	@Meta.AD(
		deflt = "" + CommercePricingConstants.DISCOUNT_CHAIN_METHOD,
		name = "discount-application-strategy", required = false
	)
	public String commerceDiscountApplicationStrategy();

}