/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.pricing.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommercePricingClass service. Represents a row in the &quot;CommercePricingClass&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.pricing.model.impl.CommercePricingClassModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.pricing.model.impl.CommercePricingClassImpl</code>.
 * </p>
 *
 * @author Riccardo Alberti
 * @see CommercePricingClass
 * @generated
 */
@ProviderType
public interface CommercePricingClassModel
	extends BaseModel<CommercePricingClass>, ShardedModel, StagedGroupedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce pricing class model instance should use the {@link CommercePricingClass} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce pricing class.
	 *
	 * @return the primary key of this commerce pricing class
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce pricing class.
	 *
	 * @param primaryKey the primary key of this commerce pricing class
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this commerce pricing class.
	 *
	 * @return the uuid of this commerce pricing class
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this commerce pricing class.
	 *
	 * @param uuid the uuid of this commerce pricing class
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the external reference code of this commerce pricing class.
	 *
	 * @return the external reference code of this commerce pricing class
	 */
	@AutoEscape
	public String getExternalReferenceCode();

	/**
	 * Sets the external reference code of this commerce pricing class.
	 *
	 * @param externalReferenceCode the external reference code of this commerce pricing class
	 */
	public void setExternalReferenceCode(String externalReferenceCode);

	/**
	 * Returns the commerce pricing class ID of this commerce pricing class.
	 *
	 * @return the commerce pricing class ID of this commerce pricing class
	 */
	public long getCommercePricingClassId();

	/**
	 * Sets the commerce pricing class ID of this commerce pricing class.
	 *
	 * @param commercePricingClassId the commerce pricing class ID of this commerce pricing class
	 */
	public void setCommercePricingClassId(long commercePricingClassId);

	/**
	 * Returns the group ID of this commerce pricing class.
	 *
	 * @return the group ID of this commerce pricing class
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce pricing class.
	 *
	 * @param groupId the group ID of this commerce pricing class
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce pricing class.
	 *
	 * @return the company ID of this commerce pricing class
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce pricing class.
	 *
	 * @param companyId the company ID of this commerce pricing class
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce pricing class.
	 *
	 * @return the user ID of this commerce pricing class
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce pricing class.
	 *
	 * @param userId the user ID of this commerce pricing class
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce pricing class.
	 *
	 * @return the user uuid of this commerce pricing class
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce pricing class.
	 *
	 * @param userUuid the user uuid of this commerce pricing class
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce pricing class.
	 *
	 * @return the user name of this commerce pricing class
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce pricing class.
	 *
	 * @param userName the user name of this commerce pricing class
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce pricing class.
	 *
	 * @return the create date of this commerce pricing class
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce pricing class.
	 *
	 * @param createDate the create date of this commerce pricing class
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce pricing class.
	 *
	 * @return the modified date of this commerce pricing class
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce pricing class.
	 *
	 * @param modifiedDate the modified date of this commerce pricing class
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the title of this commerce pricing class.
	 *
	 * @return the title of this commerce pricing class
	 */
	@AutoEscape
	public String getTitle();

	/**
	 * Sets the title of this commerce pricing class.
	 *
	 * @param title the title of this commerce pricing class
	 */
	public void setTitle(String title);

	/**
	 * Returns the description of this commerce pricing class.
	 *
	 * @return the description of this commerce pricing class
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this commerce pricing class.
	 *
	 * @param description the description of this commerce pricing class
	 */
	public void setDescription(String description);

	/**
	 * Returns the last publish date of this commerce pricing class.
	 *
	 * @return the last publish date of this commerce pricing class
	 */
	@Override
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this commerce pricing class.
	 *
	 * @param lastPublishDate the last publish date of this commerce pricing class
	 */
	@Override
	public void setLastPublishDate(Date lastPublishDate);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(CommercePricingClass commercePricingClass);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommercePricingClass> toCacheModel();

	@Override
	public CommercePricingClass toEscapedModel();

	@Override
	public CommercePricingClass toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}