/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.data.integration.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceDataIntegrationMessagingConfigurator.class})
public class CommerceDataIntegrationMessagingConfigurator {
    private static final int _MAXIMUM_QUEUE_SIZE = 100;
    private static final Log _log = LogFactoryUtil.getLog(CommerceDataIntegrationMessagingConfigurator.class);
    private BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    private final Map<String, ServiceRegistration<Destination>> _serviceRegistrations = new HashMap<String, ServiceRegistration<Destination>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/commerce/data_integration/executor");
        destinationConfiguration.setMaximumQueueSize(100);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the graph walker's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("destination.name", destination.getName());
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)properties);
        this._serviceRegistrations.put(destination.getName(), (ServiceRegistration<Destination>)serviceRegistration);
    }

    @Deactivate
    protected void deactivate() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations.values()) {
            Destination destination = (Destination)this._bundleContext.getService(serviceRegistration.getReference());
            serviceRegistration.unregister();
            destination.destroy();
        }
        this._serviceRegistrations.clear();
    }
}

