/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.data.integration.service.impl;

import com.liferay.commerce.data.integration.exception.CommerceDataIntegrationProcessEndDateException;
import com.liferay.commerce.data.integration.exception.CommerceDataIntegrationProcessNameException;
import com.liferay.commerce.data.integration.exception.CommerceDataIntegrationProcessStartDateException;
import com.liferay.commerce.data.integration.exception.DuplicateCommerceDataIntegrationProcessException;
import com.liferay.commerce.data.integration.model.CommerceDataIntegrationProcess;
import com.liferay.commerce.data.integration.service.base.CommerceDataIntegrationProcessLocalServiceBaseImpl;
import com.liferay.commerce.data.integration.trigger.CommerceDataIntegrationProcessTriggerHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.List;

public class CommerceDataIntegrationProcessLocalServiceImpl
extends CommerceDataIntegrationProcessLocalServiceBaseImpl {
    @ServiceReference(type=CommerceDataIntegrationProcessTriggerHelper.class)
    private CommerceDataIntegrationProcessTriggerHelper _commerceDataIntegrationProcessTriggerHelper;

    public CommerceDataIntegrationProcess addCommerceDataIntegrationProcess(long userId, String name, String type, UnicodeProperties typeSettingsUnicodeProperties, boolean system) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(user.getCompanyId(), 0L, name);
        Company company = this.companyLocalService.getCompany(user.getCompanyId());
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this.commerceDataIntegrationProcessPersistence.create(this.counterLocalService.increment());
        commerceDataIntegrationProcess.setCompanyId(company.getCompanyId());
        commerceDataIntegrationProcess.setUserId(user.getUserId());
        commerceDataIntegrationProcess.setUserName(user.getFullName());
        commerceDataIntegrationProcess.setName(name);
        commerceDataIntegrationProcess.setType(type);
        commerceDataIntegrationProcess.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        commerceDataIntegrationProcess.setSystem(system);
        commerceDataIntegrationProcess = (CommerceDataIntegrationProcess)this.commerceDataIntegrationProcessPersistence.update((BaseModel)commerceDataIntegrationProcess);
        this.resourceLocalService.addResources(company.getCompanyId(), 0L, user.getUserId(), CommerceDataIntegrationProcess.class.getName(), commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId(), false, true, true);
        return commerceDataIntegrationProcess;
    }

    @Override
    @SystemEvent(type=1)
    public CommerceDataIntegrationProcess deleteCommerceDataIntegrationProcess(CommerceDataIntegrationProcess commerceDataIntegrationProcess) throws PortalException {
        if (commerceDataIntegrationProcess.isSystem()) {
            return commerceDataIntegrationProcess;
        }
        this.commerceDataIntegrationProcessLogLocalService.deleteCommerceDataIntegrationProcessLogs(commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId());
        this.commerceDataIntegrationProcessPersistence.remove((BaseModel)commerceDataIntegrationProcess);
        this.resourceLocalService.deleteResource((AuditedModel)commerceDataIntegrationProcess, 4);
        this._commerceDataIntegrationProcessTriggerHelper.deleteScheduledTask(commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId());
        return commerceDataIntegrationProcess;
    }

    @Override
    public CommerceDataIntegrationProcess deleteCommerceDataIntegrationProcess(long commerceDataIntegrationProcessId) throws PortalException {
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this.commerceDataIntegrationProcessPersistence.findByPrimaryKey(commerceDataIntegrationProcessId);
        return this.commerceDataIntegrationProcessLocalService.deleteCommerceDataIntegrationProcess(commerceDataIntegrationProcess);
    }

    public CommerceDataIntegrationProcess fetchCommerceDataIntegrationProcess(long companyId, String name) {
        return this.commerceDataIntegrationProcessPersistence.fetchByC_N(companyId, name);
    }

    @Override
    public CommerceDataIntegrationProcess getCommerceDataIntegrationProcess(long commerceDataIntegrationProcessId) throws PortalException {
        return this.commerceDataIntegrationProcessPersistence.findByPrimaryKey(commerceDataIntegrationProcessId);
    }

    public List<CommerceDataIntegrationProcess> getCommerceDataIntegrationProcesses(long companyId, int start, int end) {
        return this.commerceDataIntegrationProcessPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCommerceDataIntegrationProcessesCount(long companyId) {
        return this.commerceDataIntegrationProcessPersistence.countByCompanyId(companyId);
    }

    public CommerceDataIntegrationProcess updateCommerceDataIntegrationProcess(long commerceDataIntegrationProcessId, String name, UnicodeProperties typeSettingsUnicodeProperties) throws PortalException {
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this.commerceDataIntegrationProcessPersistence.findByPrimaryKey(commerceDataIntegrationProcessId);
        this.validate(commerceDataIntegrationProcess.getCompanyId(), commerceDataIntegrationProcessId, name);
        commerceDataIntegrationProcess.setName(name);
        commerceDataIntegrationProcess.setTypeSettingsProperties(typeSettingsUnicodeProperties);
        return (CommerceDataIntegrationProcess)this.commerceDataIntegrationProcessPersistence.update((BaseModel)commerceDataIntegrationProcess);
    }

    public CommerceDataIntegrationProcess updateCommerceDataIntegrationProcessTrigger(long commerceDataIntegrationProcessId, boolean active, String cronExpression, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverEnd) throws PortalException {
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this.commerceDataIntegrationProcessPersistence.fetchByPrimaryKey(commerceDataIntegrationProcessId);
        Date endDate = null;
        Date startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, CommerceDataIntegrationProcessStartDateException.class);
        if (!neverEnd) {
            endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, CommerceDataIntegrationProcessEndDateException.class);
        }
        commerceDataIntegrationProcess.setActive(active);
        commerceDataIntegrationProcess.setCronExpression(cronExpression);
        commerceDataIntegrationProcess.setStartDate(startDate);
        commerceDataIntegrationProcess.setEndDate(endDate);
        commerceDataIntegrationProcess = (CommerceDataIntegrationProcess)this.commerceDataIntegrationProcessPersistence.update((BaseModel)commerceDataIntegrationProcess);
        if (active) {
            this._commerceDataIntegrationProcessTriggerHelper.addScheduledTask(commerceDataIntegrationProcessId, cronExpression, startDate, endDate);
        } else {
            this._commerceDataIntegrationProcessTriggerHelper.deleteScheduledTask(commerceDataIntegrationProcessId);
        }
        return commerceDataIntegrationProcess;
    }

    protected void validate(long companyId, long commerceDataIntegrationProcessId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceDataIntegrationProcessNameException("Commerce data integration process name cannot be null forcompany " + companyId);
        }
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this.commerceDataIntegrationProcessPersistence.fetchByC_N(companyId, name);
        if (commerceDataIntegrationProcess == null) {
            return;
        }
        long existingCommerceDataIntegrationProcessId = commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId();
        if (commerceDataIntegrationProcessId > 0L && existingCommerceDataIntegrationProcessId == commerceDataIntegrationProcessId) {
            return;
        }
        throw new DuplicateCommerceDataIntegrationProcessException("A commerce data integration process with the name " + name + " already exists");
    }
}

