Liferay.Loader.define('commerce-dashboard-web$dnd-core@11.1.3/lib/DragDropManagerImpl', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { createStore } from 'redux';
        import { reduce } from './reducers';
        import { createDragDropActions } from './actions/dragDrop';
        import { DragDropMonitorImpl } from './DragDropMonitorImpl';
        import { HandlerRegistryImpl } from './HandlerRegistryImpl';
        function makeStoreInstance(debugMode) {
            // TODO: if we ever make a react-native version of this,
            // we'll need to consider how to pull off dev-tooling
            const reduxDevTools = typeof window !== 'undefined' && window.__REDUX_DEVTOOLS_EXTENSION__;
            return createStore(reduce, debugMode && reduxDevTools && reduxDevTools({
                name: 'dnd-core',
                instanceId: 'dnd-core'
            }));
        }
        export class DragDropManagerImpl {
            constructor(debugMode = false) {
                this.isSetUp = false;
                this.handleRefCountChange = () => {
                    const shouldSetUp = this.store.getState().refCount > 0;
                    if (this.backend) {
                        if (shouldSetUp && !this.isSetUp) {
                            this.backend.setup();
                            this.isSetUp = true;
                        } else if (!shouldSetUp && this.isSetUp) {
                            this.backend.teardown();
                            this.isSetUp = false;
                        }
                    }
                };
                const store = makeStoreInstance(debugMode);
                this.store = store;
                this.monitor = new DragDropMonitorImpl(store, new HandlerRegistryImpl(store));
                store.subscribe(this.handleRefCountChange);
            }
            receiveBackend(backend) {
                this.backend = backend;
            }
            getMonitor() {
                return this.monitor;
            }
            getBackend() {
                return this.backend;
            }
            getRegistry() {
                return this.monitor.registry;
            }
            getActions() {
                /* eslint-disable-next-line @typescript-eslint/no-this-alias */
                const manager = this;
                const { dispatch } = this.store;
                function bindActionCreator(actionCreator) {
                    return (...args) => {
                        const action = actionCreator.apply(manager, args);
                        if (typeof action !== 'undefined') {
                            dispatch(action);
                        }
                    };
                }
                const actions = createDragDropActions(this);
                return Object.keys(actions).reduce((boundActions, key) => {
                    const action = actions[key];
                    boundActions[key] = bindActionCreator(action);
                    return boundActions;
                }, {});
            }
            dispatch(action) {
                this.store.dispatch(action);
            }
        }
    }
});
//# sourceMappingURL=DragDropManagerImpl.js.map