Liferay.Loader.define('commerce-dashboard-web$lodash-es@4.17.15/isError', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseGetTag from './_baseGetTag.js';
  import isObjectLike from './isObjectLike.js';
  import isPlainObject from './isPlainObject.js';

  /** `Object#toString` result references. */
  var domExcTag = '[object DOMException]',
      errorTag = '[object Error]';

  /**
   * Checks if `value` is an `Error`, `EvalError`, `RangeError`, `ReferenceError`,
   * `SyntaxError`, `TypeError`, or `URIError` object.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an error object, else `false`.
   * @example
   *
   * _.isError(new Error);
   * // => true
   *
   * _.isError(Error);
   * // => false
   */
  function isError(value) {
    if (!isObjectLike(value)) {
      return false;
    }
    var tag = baseGetTag(value);
    return tag == errorTag || tag == domExcTag || typeof value.message == 'string' && typeof value.name == 'string' && !isPlainObject(value);
  }

  export default isError;
});
//# sourceMappingURL=isError.js.map