'use strict';

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks
 */

Liferay.Loader.define('commerce-dashboard-web$fbjs@0.8.17/lib/getElementPosition', ['module', 'exports', 'require', './getElementRect'], function (module, exports, require) {
  var define = undefined;
  var getElementRect = require('./getElementRect');

  /**
   * Gets an element's position in pixels relative to the viewport. The returned
   * object represents the position of the element's top left corner.
   *
   * @param {DOMElement} element
   * @return {object}
   */
  function getElementPosition(element) {
    var rect = getElementRect(element);
    return {
      x: rect.left,
      y: rect.top,
      width: rect.right - rect.left,
      height: rect.bottom - rect.top
    };
  }

  module.exports = getElementPosition;
});
//# sourceMappingURL=getElementPosition.js.map