Liferay.Loader.define("commerce-dashboard-web$d3-geo@1.11.3/src/projection/stereographic", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import { atan, cos, sin } from "../math";
  import { azimuthalInvert } from "./azimuthal";
  import projection from "./index";

  export function stereographicRaw(x, y) {
    var cy = cos(y),
        k = 1 + cos(x) * cy;
    return [cy * sin(x) / k, sin(y) / k];
  }

  stereographicRaw.invert = azimuthalInvert(function (z) {
    return 2 * atan(z);
  });

  export default function () {
    return projection(stereographicRaw).scale(250).clipAngle(142);
  }
});
//# sourceMappingURL=stereographic.js.map