Liferay.Loader.define("commerce-dashboard-web$d3-geo@1.11.3/src/contains", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import { default as polygonContains } from "./polygonContains";
  import { default as distance } from "./distance";
  import { epsilon, radians } from "./math";

  var containsObjectType = {
    Feature: function (object, point) {
      return containsGeometry(object.geometry, point);
    },
    FeatureCollection: function (object, point) {
      var features = object.features,
          i = -1,
          n = features.length;
      while (++i < n) if (containsGeometry(features[i].geometry, point)) return true;
      return false;
    }
  };

  var containsGeometryType = {
    Sphere: function () {
      return true;
    },
    Point: function (object, point) {
      return containsPoint(object.coordinates, point);
    },
    MultiPoint: function (object, point) {
      var coordinates = object.coordinates,
          i = -1,
          n = coordinates.length;
      while (++i < n) if (containsPoint(coordinates[i], point)) return true;
      return false;
    },
    LineString: function (object, point) {
      return containsLine(object.coordinates, point);
    },
    MultiLineString: function (object, point) {
      var coordinates = object.coordinates,
          i = -1,
          n = coordinates.length;
      while (++i < n) if (containsLine(coordinates[i], point)) return true;
      return false;
    },
    Polygon: function (object, point) {
      return containsPolygon(object.coordinates, point);
    },
    MultiPolygon: function (object, point) {
      var coordinates = object.coordinates,
          i = -1,
          n = coordinates.length;
      while (++i < n) if (containsPolygon(coordinates[i], point)) return true;
      return false;
    },
    GeometryCollection: function (object, point) {
      var geometries = object.geometries,
          i = -1,
          n = geometries.length;
      while (++i < n) if (containsGeometry(geometries[i], point)) return true;
      return false;
    }
  };

  function containsGeometry(geometry, point) {
    return geometry && containsGeometryType.hasOwnProperty(geometry.type) ? containsGeometryType[geometry.type](geometry, point) : false;
  }

  function containsPoint(coordinates, point) {
    return distance(coordinates, point) === 0;
  }

  function containsLine(coordinates, point) {
    var ab = distance(coordinates[0], coordinates[1]),
        ao = distance(coordinates[0], point),
        ob = distance(point, coordinates[1]);
    return ao + ob <= ab + epsilon;
  }

  function containsPolygon(coordinates, point) {
    return !!polygonContains(coordinates.map(ringRadians), pointRadians(point));
  }

  function ringRadians(ring) {
    return ring = ring.map(pointRadians), ring.pop(), ring;
  }

  function pointRadians(point) {
    return [point[0] * radians, point[1] * radians];
  }

  export default function (object, point) {
    return (object && containsObjectType.hasOwnProperty(object.type) ? containsObjectType[object.type] : containsGeometry)(object, point);
  }
});
//# sourceMappingURL=contains.js.map