Liferay.Loader.define("commerce-dashboard-web$d3-geo@1.11.3/src/adder", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  // Adds floating point numbers with twice the normal precision.
  // Reference: J. R. Shewchuk, Adaptive Precision Floating-Point Arithmetic and
  // Fast Robust Geometric Predicates, Discrete & Computational Geometry 18(3)
  // 305–363 (1997).
  // Code adapted from GeographicLib by Charles F. F. Karney,
  // http://geographiclib.sourceforge.net/

  export default function () {
    return new Adder();
  }

  function Adder() {
    this.reset();
  }

  Adder.prototype = {
    constructor: Adder,
    reset: function () {
      this.s = // rounded value
      this.t = 0; // exact error
    },
    add: function (y) {
      add(temp, y, this.t);
      add(this, temp.s, this.s);
      if (this.s) this.t += temp.t;else this.s = temp.t;
    },
    valueOf: function () {
      return this.s;
    }
  };

  var temp = new Adder();

  function add(adder, a, b) {
    var x = adder.s = a + b,
        bv = x - a;
    adder.t = a - (x - bv) + (b - bv);
  }
});
//# sourceMappingURL=adder.js.map