Liferay.Loader.define("commerce-dashboard-web$d3-hierarchy@1.1.8/src/treemap/resquarify", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import treemapDice from "./dice";
  import treemapSlice from "./slice";
  import { phi, squarifyRatio } from "./squarify";

  export default (function custom(ratio) {

    function resquarify(parent, x0, y0, x1, y1) {
      if ((rows = parent._squarify) && rows.ratio === ratio) {
        var rows,
            row,
            nodes,
            i,
            j = -1,
            n,
            m = rows.length,
            value = parent.value;

        while (++j < m) {
          row = rows[j], nodes = row.children;
          for (i = row.value = 0, n = nodes.length; i < n; ++i) row.value += nodes[i].value;
          if (row.dice) treemapDice(row, x0, y0, x1, y0 += (y1 - y0) * row.value / value);else treemapSlice(row, x0, y0, x0 += (x1 - x0) * row.value / value, y1);
          value -= row.value;
        }
      } else {
        parent._squarify = rows = squarifyRatio(ratio, parent, x0, y0, x1, y1);
        rows.ratio = ratio;
      }
    }

    resquarify.ratio = function (x) {
      return custom((x = +x) > 1 ? x : 1);
    };

    return resquarify;
  })(phi);
});
//# sourceMappingURL=resquarify.js.map