Liferay.Loader.define('commerce-dashboard-web$resize-observer-polyfill@1.5.1/src/shims/requestAnimationFrame', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    import global from './global.js';

    /**
     * A shim for the requestAnimationFrame which falls back to the setTimeout if
     * first one is not supported.
     *
     * @returns {number} Requests' identifier.
     */
    export default (() => {
        if (typeof requestAnimationFrame === 'function') {
            // It's required to use a bounded function because IE sometimes throws
            // an "Invalid calling object" error if rAF is invoked without the global
            // object on the left hand side.
            return requestAnimationFrame.bind(global);
        }

        return callback => setTimeout(() => callback(Date.now()), 1000 / 60);
    })();
});
//# sourceMappingURL=requestAnimationFrame.js.map