"use strict";

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks
 */

/**
 * Simple function for formatting strings.
 *
 * Replaces placeholders with values passed as extra arguments
 *
 * @param {string} format the base string
 * @param ...args the values to insert
 * @return {string} the replaced string
 */

Liferay.Loader.define("commerce-dashboard-web$fbjs@0.8.17/lib/sprintf", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function sprintf(format) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var index = 0;
    return format.replace(/%s/g, function (match) {
      return args[index++];
    });
  }

  module.exports = sprintf;
});
//# sourceMappingURL=sprintf.js.map