Liferay.Loader.define("commerce-dashboard-web$d3-geo@1.11.3/src/projection/transverseMercator", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import { atan, exp, halfPi, log, tan } from "../math";
  import { mercatorProjection } from "./mercator";

  export function transverseMercatorRaw(lambda, phi) {
    return [log(tan((halfPi + phi) / 2)), -lambda];
  }

  transverseMercatorRaw.invert = function (x, y) {
    return [-y, 2 * atan(exp(x)) - halfPi];
  };

  export default function () {
    var m = mercatorProjection(transverseMercatorRaw),
        center = m.center,
        rotate = m.rotate;

    m.center = function (_) {
      return arguments.length ? center([-_[1], _[0]]) : (_ = center(), [_[1], -_[0]]);
    };

    m.rotate = function (_) {
      return arguments.length ? rotate([_[0], _[1], _.length > 2 ? _[2] + 90 : 90]) : (_ = rotate(), [_[0], _[1], _[2] - 90]);
    };

    return rotate([0, 0, 90]).scale(159.155);
  }
});
//# sourceMappingURL=transverseMercator.js.map