/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public class CommerceOrderServiceWrapper
implements CommerceOrderService,
ServiceWrapper<CommerceOrderService> {
    private CommerceOrderService _commerceOrderService;

    public CommerceOrderServiceWrapper() {
        this(null);
    }

    public CommerceOrderServiceWrapper(CommerceOrderService commerceOrderService) {
        this._commerceOrderService = commerceOrderService;
    }

    @Override
    public FileEntry addAttachmentFileEntry(String externalReferenceCode, long userId, long commerceOrderId, String fileName, InputStream inputStream) throws PortalException {
        return this._commerceOrderService.addAttachmentFileEntry(externalReferenceCode, userId, commerceOrderId, fileName, inputStream);
    }

    @Override
    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId) throws PortalException {
        return this._commerceOrderService.addCommerceOrder(groupId, commerceAccountId, commerceCurrencyCode, commerceOrderTypeId);
    }

    @Override
    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.addOrUpdateCommerceOrder(externalReferenceCode, groupId, billingAddressId, commerceAccountId, commerceCurrencyCode, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, String commerceCurrencyCode, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.addOrUpdateCommerceOrder(externalReferenceCode, groupId, billingAddressId, commerceAccountId, commerceCurrencyCode, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    @Override
    public void deleteAttachmentFileEntry(long attachmentFileEntryId, long commerceOrderId) throws PortalException {
        this._commerceOrderService.deleteAttachmentFileEntry(attachmentFileEntryId, commerceOrderId);
    }

    @Override
    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        this._commerceOrderService.deleteCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        return this._commerceOrderService.executeWorkflowTransition(commerceOrderId, workflowTaskId, transitionName, comment);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceOrderId);
    }

    @Override
    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceAccountId, groupId, userId, orderStatus);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(uuid, groupId);
    }

    @Override
    public CommerceOrder fetchCommerceOrderByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    @Override
    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.getCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this._commerceOrderService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, orderStatuses);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, orderStatuses, start, end);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    @Override
    public int getCommerceOrdersCount(long groupId) throws PortalException {
        return this._commerceOrderService.getCommerceOrdersCount(groupId);
    }

    @Override
    public int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        return this._commerceOrderService.getCommerceOrdersCount(groupId, commerceAccountId);
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return this._commerceOrderService.getOSGiServiceIdentifier();
    }

    @Override
    public List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    @Override
    public long getPendingCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrdersCount(companyId, groupId);
    }

    @Override
    public int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    @Override
    public List<CommerceOrder> getPlacedCommerceOrders(long companyId, long groupId, int start, int end) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrders(companyId, groupId, start, end);
    }

    @Override
    public List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    @Override
    public long getPlacedCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrdersCount(companyId, groupId);
    }

    @Override
    public int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserOpenCommerceOrders(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this._commerceOrderService.getUserOpenCommerceOrders(companyId, groupId, keywords, start, end, sort);
    }

    @Override
    public List<CommerceOrder> getUserPendingCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserPendingCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserPendingCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserPendingCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end, sort);
    }

    @Override
    public long getUserPlacedCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderService.mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.recalculatePrice(commerceOrderId, commerceContext);
    }

    @Override
    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.reorderCommerceOrder(commerceOrderId, commerceContext);
    }

    @Override
    public CommerceOrder resetCommerceOrderAddresses(long commerceOrderId, boolean billingAddress, boolean shippingAddress) throws PortalException {
        return this._commerceOrderService.resetCommerceOrderAddresses(commerceOrderId, billingAddress, shippingAddress);
    }

    @Override
    public CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean deliveryCommerceTermEntry, boolean paymentCommerceTermEntry) throws PortalException {
        return this._commerceOrderService.resetTermsAndConditions(commerceOrderId, deliveryCommerceTermEntry, paymentCommerceTermEntry);
    }

    @Override
    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        return this._commerceOrderService.updateBillingAddress(commerceOrderId, billingAddressId);
    }

    @Override
    public CommerceOrder updateBillingAddress(long commerceOrderId, long countryId, long regionId, String city, String description, String name, String street1, String street2, String street3, String subtype, String phoneNumber, String zip, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateBillingAddress(commerceOrderId, countryId, regionId, city, description, name, street1, street2, street3, subtype, phoneNumber, zip, serviceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    @Override
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal subtotal, BigDecimal total) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, purchaseOrderNumber, shippingAmount, shippingOptionName, subtotal, total);
    }

    @Override
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalDiscountAmount, totalWithTaxAmount);
    }

    @Override
    public CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderExternalReferenceCode(externalReferenceCode, commerceOrderId);
    }

    @Override
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    @Override
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, shippingDiscountPercentageLevel1WithTaxAmount, shippingDiscountPercentageLevel2WithTaxAmount, shippingDiscountPercentageLevel3WithTaxAmount, shippingDiscountPercentageLevel4WithTaxAmount, shippingDiscountWithTaxAmount, shippingWithTaxAmount, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, subtotalDiscountPercentageLevel1WithTaxAmount, subtotalDiscountPercentageLevel2WithTaxAmount, subtotalDiscountPercentageLevel3WithTaxAmount, subtotalDiscountPercentageLevel4WithTaxAmount, subtotalDiscountWithTaxAmount, subtotalWithTaxAmount, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, totalDiscountPercentageLevel1WithTaxAmount, totalDiscountPercentageLevel2WithTaxAmount, totalDiscountPercentageLevel3WithTaxAmount, totalDiscountPercentageLevel4WithTaxAmount, totalDiscountWithTaxAmount, totalWithTaxAmount);
    }

    @Override
    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        return this._commerceOrderService.updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    @Override
    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        return this._commerceOrderService.updateCommerceShippingMethod(commerceOrderId, commerceShippingMethodId, commerceShippingOptionName, commerceContext, locale);
    }

    @Override
    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    @Override
    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    @Override
    @Deprecated
    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        return this._commerceOrderService.updatePaymentStatus(commerceOrderId, paymentStatus);
    }

    @Override
    @Deprecated
    public CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        return this._commerceOrderService.updatePaymentStatusAndTransactionId(commerceOrderId, paymentStatus, transactionId);
    }

    @Override
    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        return this._commerceOrderService.updatePrintedNote(commerceOrderId, printedNote);
    }

    @Override
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        return this._commerceOrderService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    @Override
    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        return this._commerceOrderService.updateShippingAddress(commerceOrderId, shippingAddressId);
    }

    @Override
    public CommerceOrder updateShippingAddress(long commerceOrderId, long countryId, long regionId, String city, String description, String name, String phoneNumber, String street1, String street2, String street3, String subtype, String zip, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateShippingAddress(commerceOrderId, countryId, regionId, city, description, name, phoneNumber, street1, street2, street3, subtype, zip, serviceContext);
    }

    @Override
    public CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        return this._commerceOrderService.updateTermsAndConditions(commerceOrderId, deliveryCommerceTermEntryId, paymentCommerceTermEntryId, languageId);
    }

    public CommerceOrderService getWrappedService() {
        return this._commerceOrderService;
    }

    public void setWrappedService(CommerceOrderService commerceOrderService) {
        this._commerceOrderService = commerceOrderService;
    }
}

