/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceShipmentServiceUtil {
    private static final Snapshot<CommerceShipmentService> _serviceSnapshot = new Snapshot(CommerceShipmentServiceUtil.class, CommerceShipmentService.class);

    public static CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().addCommerceShipment(commerceOrderId, serviceContext);
    }

    public static CommerceShipment addCommerceShipment(String externalReferenceCode, long groupId, long commerceAccountId, long commerceAddressId, long commerceShippingMethodId, String commerceShippingOptionName, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().addCommerceShipment(externalReferenceCode, groupId, commerceAccountId, commerceAddressId, commerceShippingMethodId, commerceShippingOptionName, serviceContext);
    }

    @Deprecated
    public static void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipmentServiceUtil.getService().deleteCommerceShipment(commerceShipmentId);
    }

    public static void deleteCommerceShipment(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipmentServiceUtil.getService().deleteCommerceShipment(commerceShipmentId, restoreStockQuantity);
    }

    public static CommerceShipment fetchCommerceShipmentByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return CommerceShipmentServiceUtil.getService().fetchCommerceShipmentByExternalReferenceCode(companyId, externalReferenceCode);
    }

    public static CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipment(commerceShipmentId);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, status, start, end, orderByComparator);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, start, end, orderByComparator);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, commerceAddressId, start, end, orderByComparator);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus, int start, int end) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus, start, end);
    }

    public static List<CommerceShipment> getCommerceShipmentsByOrderId(long commerceOrderId, int start, int end) {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsByOrderId(commerceOrderId, start, end);
    }

    public static int getCommerceShipmentsCount(long companyId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId);
    }

    public static int getCommerceShipmentsCount(long companyId, int status) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId, status);
    }

    public static int getCommerceShipmentsCount(long companyId, long commerceAddressId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId, commerceAddressId);
    }

    public static int getCommerceShipmentsCount(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus);
    }

    public static int getCommerceShipmentsCountByOrderId(long commerceOrderId) {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCountByOrderId(commerceOrderId);
    }

    public static String getOSGiServiceIdentifier() {
        return CommerceShipmentServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static CommerceShipment reprocessCommerceShipment(long commerceShipmentId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().reprocessCommerceShipment(commerceShipmentId);
    }

    public static CommerceShipment updateAddress(String externalReferenceCode, long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateAddress(externalReferenceCode, commerceShipmentId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public static CommerceShipment updateCarrierDetails(long commerceShipmentId, long commerceShippingMethodId, String carrier, String trackingNumber, String trackingURL) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCarrierDetails(commerceShipmentId, commerceShippingMethodId, carrier, trackingNumber, trackingURL);
    }

    public static CommerceShipment updateCommerceShipment(CommerceShipment commerceShipment) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCommerceShipment(commerceShipment);
    }

    public static CommerceShipment updateCommerceShipment(long commerceShipmentId, long commerceShippingMethodId, String carrier, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, String trackingNumber, String trackingURL, int status, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCommerceShipment(commerceShipmentId, commerceShippingMethodId, carrier, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, trackingNumber, trackingURL, status, serviceContext);
    }

    public static CommerceShipment updateCommerceShipment(long commerceShipmentId, long commerceShippingMethodId, String carrier, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, String trackingNumber, String trackingURL, int status, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCommerceShipment(commerceShipmentId, commerceShippingMethodId, carrier, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, trackingNumber, trackingURL, status, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public static CommerceShipment updateExpectedDate(long commerceShipmentId, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateExpectedDate(commerceShipmentId, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public static CommerceShipment updateExternalReferenceCode(long commerceShipmentId, String externalReferenceCode) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateExternalReferenceCode(commerceShipmentId, externalReferenceCode);
    }

    public static CommerceShipment updateShippingDate(long commerceShipmentId, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateShippingDate(commerceShipmentId, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute);
    }

    public static CommerceShipment updateStatus(long commerceShipmentId, int status) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateStatus(commerceShipmentId, status);
    }

    public static CommerceShipmentService getService() {
        return (CommerceShipmentService)_serviceSnapshot.get();
    }
}

