/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.util.comparator;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.util.OrderByComparator;

public class CommerceOrderIdComparator
extends OrderByComparator<CommerceOrder> {
    public static final String ORDER_BY_ASC = "CommerceOrder.commerceOrderId ASC";
    public static final String ORDER_BY_DESC = "CommerceOrder.commerceOrderId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"commerceOrderId"};
    private static final CommerceOrderIdComparator _INSTANCE_ASCENDING = new CommerceOrderIdComparator(true);
    private static final CommerceOrderIdComparator _INSTANCE_DESCENDING = new CommerceOrderIdComparator(false);
    private final boolean _ascending;

    public static CommerceOrderIdComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    public int compare(CommerceOrder commerceOrder1, CommerceOrder commerceOrder2) {
        int value = Long.compare(commerceOrder1.getCommerceOrderId(), commerceOrder2.getCommerceOrderId());
        if (this._ascending) {
            return value;
        }
        return Math.negateExact(value);
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    private CommerceOrderIdComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

