/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.model;

import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class CommerceReturn {
    private final long _accountId;
    private final long _channelGroupId;
    private final long _channelId;
    private final String _channelName;
    private final Date _createDate;
    private final String _currencyCode;
    private final String _currencySymbol;
    private final String _externalReferenceCode;
    private final long _id;
    private final String _note;
    private final ObjectEntry _objectEntry;
    private final long _orderId;
    private final int _requestedItems;
    private final String _returnStatus;
    private final int _status;
    private final BigDecimal _totalAmount;

    public CommerceReturn(ObjectEntry objectEntry) {
        Map objectEntryValues = objectEntry.getValues();
        this._objectEntry = objectEntry;
        this._accountId = (Long)((Serializable)objectEntryValues.get("r_accountToCommerceReturns_accountEntryId"));
        this._channelGroupId = (Long)((Serializable)objectEntryValues.get("channelGroupId"));
        this._channelId = (Long)((Serializable)objectEntryValues.get("channelId"));
        this._channelName = (String)objectEntryValues.get("channelName");
        this._createDate = objectEntry.getCreateDate();
        this._currencyCode = (String)objectEntryValues.get("currencyCode");
        this._currencySymbol = (String)objectEntryValues.get("currencySymbol");
        this._externalReferenceCode = objectEntry.getExternalReferenceCode();
        this._id = objectEntry.getPrimaryKey();
        this._note = (String)objectEntryValues.get("note");
        this._orderId = (Long)((Serializable)objectEntryValues.get("r_commerceOrderToCommerceReturns_commerceOrderId"));
        this._requestedItems = GetterUtil.getInteger((String)String.valueOf(objectEntryValues.get("requestedItems")));
        this._returnStatus = (String)objectEntryValues.get("returnStatus");
        this._status = objectEntry.getStatus();
        this._totalAmount = new BigDecimal(GetterUtil.getDouble(objectEntryValues.get("totalAmount")));
    }

    public long getAccountId() {
        return this._accountId;
    }

    public long getChannelGroupId() {
        return this._channelGroupId;
    }

    public long getChannelId() {
        return this._channelId;
    }

    public String getChannelName() {
        return this._channelName;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public String getCurrencyCode() {
        return this._currencyCode;
    }

    public String getCurrencySymbol() {
        return this._currencySymbol;
    }

    public String getExternalReferenceCode() {
        return this._externalReferenceCode;
    }

    public long getId() {
        return this._id;
    }

    public String getNote() {
        return this._note;
    }

    public ObjectEntry getObjectEntry() {
        return this._objectEntry;
    }

    public long getOrderId() {
        return this._orderId;
    }

    public int getRequestedItems() {
        return this._requestedItems;
    }

    public String getReturnStatus() {
        return this._returnStatus;
    }

    public int getStatus() {
        return this._status;
    }

    public BigDecimal getTotalAmount() {
        return this._totalAmount;
    }
}

