/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.context;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.commerce.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.currency.util.comparator.CommerceCurrencyPriorityComparator;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.util.AccountEntryAllowedTypesUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class BaseCommerceContext
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceContext.class);
    private AccountEntry _accountEntry;
    private String[] _accountEntryAllowedTypes;
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AccountGroupLocalService _accountGroupLocalService;
    private long[] _commerceAccountGroupIds;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final long _commerceAccountId;
    private final CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    private final long _commerceChannelGroupId;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderService _commerceOrderService;
    private final long _companyId;
    private final long _orderId;

    public BaseCommerceContext(long companyId, long commerceChannelGroupId, long orderId, long commerceAccountId, AccountEntryLocalService accountEntryLocalService, AccountGroupLocalService accountGroupLocalService, CommerceChannelAccountEntryRelLocalService commerceChannelAccountEntryRelLocalService, CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderService commerceOrderService, ConfigurationProvider configurationProvider) {
        this._companyId = companyId;
        this._commerceChannelGroupId = commerceChannelGroupId;
        this._orderId = orderId;
        this._commerceAccountId = commerceAccountId;
        this._accountEntryLocalService = accountEntryLocalService;
        this._accountGroupLocalService = accountGroupLocalService;
        this._commerceChannelAccountEntryRelLocalService = commerceChannelAccountEntryRelLocalService;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderService = commerceOrderService;
        try {
            if (this.getCommerceChannelGroupId() > 0L) {
                this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._commerceChannelGroupId, "com.liferay.commerce.account"));
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    @Override
    public AccountEntry getAccountEntry() throws PortalException {
        if (this._accountEntry != null) {
            return this._accountEntry;
        }
        if (this._commerceAccountId <= 0L) {
            return this._accountEntryLocalService.getGuestAccountEntry(this._companyId);
        }
        this._accountEntry = this._accountEntryLocalService.getAccountEntry(this._commerceAccountId);
        return this._accountEntry;
    }

    @Override
    public String[] getAccountEntryAllowedTypes() throws PortalException {
        if (this._accountEntryAllowedTypes != null) {
            return this._accountEntryAllowedTypes;
        }
        this._accountEntryAllowedTypes = AccountEntryAllowedTypesUtil.getAllowedTypes(this.getCommerceSiteType());
        return this._accountEntryAllowedTypes;
    }

    @Override
    public long[] getCommerceAccountGroupIds() throws PortalException {
        if (this._commerceAccountGroupIds != null) {
            return (long[])this._commerceAccountGroupIds.clone();
        }
        AccountEntry accountEntry = this.getAccountEntry();
        if (accountEntry == null) {
            return new long[0];
        }
        this._commerceAccountGroupIds = this._accountGroupLocalService.getAccountGroupIds(accountEntry.getAccountEntryId());
        return (long[])this._commerceAccountGroupIds.clone();
    }

    @Override
    public long getCommerceChannelGroupId() throws PortalException {
        return this._commerceChannelGroupId;
    }

    @Override
    public long getCommerceChannelId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(this._commerceChannelGroupId);
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getCommerceChannelId();
    }

    @Override
    public CommerceCurrency getCommerceCurrency() throws PortalException {
        CommerceCurrency commerceCurrency;
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel;
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(this._commerceChannelGroupId);
        AccountEntry accountEntry = this.getAccountEntry();
        if (accountEntry != null && (commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannel.getCommerceChannelId(), 6)) != null && (commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceChannelAccountEntryRel.getClassPK())).isActive()) {
            this._commerceCurrency = commerceCurrency;
            return this._commerceCurrency;
        }
        this._commerceCurrency = this._getCommerceCurrency(this._companyId, commerceChannel.getCommerceCurrencyCode());
        return this._commerceCurrency;
    }

    @Override
    public CommerceOrder getCommerceOrder() {
        try {
            this._commerceOrder = this._commerceOrderService.fetchCommerceOrder(this._orderId);
            return this._commerceOrder;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    @Override
    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    private CommerceCurrency _getCommerceCurrency(long companyId, String currencyCode) {
        CommerceCurrency commerceCurrency;
        block5: {
            commerceCurrency = null;
            try {
                commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(companyId, currencyCode);
            }
            catch (NoSuchCurrencyException noSuchCurrencyException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)noSuchCurrencyException);
            }
        }
        if (commerceCurrency != null && commerceCurrency.isActive()) {
            return commerceCurrency;
        }
        commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(companyId);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        List commerceCurrencies = this._commerceCurrencyLocalService.getCommerceCurrencies(companyId, true, -1, -1, (OrderByComparator)CommerceCurrencyPriorityComparator.getInstance((boolean)true));
        if (!commerceCurrencies.isEmpty()) {
            commerceCurrency = (CommerceCurrency)commerceCurrencies.get(0);
        }
        return commerceCurrency;
    }
}

