/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.util;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.friendly.url.provider.FriendlyURLSeparatorProvider;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;

public class CommerceOrderInfoItemUtil {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderInfoItemUtil.class);

    public static CommerceOrder getCommerceOrder(CommerceOrderService commerceOrderService, HttpServletRequest httpServletRequest) {
        CommerceOrder commerceOrder = null;
        InfoItemReference infoItemReference = (InfoItemReference)httpServletRequest.getAttribute("INFO_ITEM_REFERENCE");
        if (infoItemReference != null) {
            try {
                ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
                commerceOrder = commerceOrderService.getCommerceOrder(classPKInfoItemIdentifier.getClassPK());
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                return null;
            }
        }
        if (commerceOrder == null) {
            Object infoItem = httpServletRequest.getAttribute("INFO_ITEM");
            if (!(infoItem instanceof CommerceOrder)) {
                return null;
            }
            commerceOrder = (CommerceOrder)infoItem;
        }
        return commerceOrder;
    }

    public static String getCommerceOrderFriendlyURL(FriendlyURLSeparatorProvider friendlyURLSeparatorProvider, HttpServletRequest httpServletRequest) {
        if (friendlyURLSeparatorProvider == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String friendlyURLSeparator = friendlyURLSeparatorProvider.getFriendlyURLSeparator(themeDisplay.getCompanyId(), CommerceOrder.class.getName());
        if (Validator.isNull((String)friendlyURLSeparator)) {
            friendlyURLSeparator = "/order/";
        }
        return CommerceOrderInfoItemUtil._getSiteDefaultURL(themeDisplay) + friendlyURLSeparator;
    }

    private static String _getSiteDefaultURL(ThemeDisplay themeDisplay) {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        return HtmlUtil.escape((String)group.getDisplayURL(themeDisplay, layout.isPrivateLayout()));
    }
}

