/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public class CommerceOrderServiceUtil {
    private static final Snapshot<CommerceOrderService> _serviceSnapshot = new Snapshot(CommerceOrderServiceUtil.class, CommerceOrderService.class);

    public static FileEntry addAttachmentFileEntry(String externalReferenceCode, long userId, long commerceOrderId, String fileName, InputStream inputStream) throws PortalException {
        return CommerceOrderServiceUtil.getService().addAttachmentFileEntry(externalReferenceCode, userId, commerceOrderId, fileName, inputStream);
    }

    public static CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId) throws PortalException {
        return CommerceOrderServiceUtil.getService().addCommerceOrder(groupId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId);
    }

    public static CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().addOrUpdateCommerceOrder(externalReferenceCode, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public static CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long billingAddressId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, int orderStatus, int paymentStatus, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalWithTaxAmount, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().addOrUpdateCommerceOrder(externalReferenceCode, groupId, billingAddressId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, orderStatus, paymentStatus, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalWithTaxAmount, commerceContext, serviceContext);
    }

    public static CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    public static void deleteAttachmentFileEntry(long attachmentFileEntryId, long commerceOrderId) throws PortalException {
        CommerceOrderServiceUtil.getService().deleteAttachmentFileEntry(attachmentFileEntryId, commerceOrderId);
    }

    public static void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrderServiceUtil.getService().deleteCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        return CommerceOrderServiceUtil.getService().executeWorkflowTransition(commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public static CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(commerceOrderId);
    }

    @Deprecated
    public static CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
    }

    public static CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(commerceAccountId, groupId, userId, orderStatus);
    }

    public static CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(uuid, groupId);
    }

    public static CommerceOrder fetchCommerceOrderByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public static CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrders(groupId, orderStatuses);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrders(groupId, orderStatuses, start, end);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public static int getCommerceOrdersCount(long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrdersCount(groupId);
    }

    public static int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrdersCount(groupId, commerceAccountId);
    }

    public static String getOSGiServiceIdentifier() {
        return CommerceOrderServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPendingCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    public static long getPendingCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPendingCommerceOrdersCount(companyId, groupId);
    }

    public static int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPendingCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    public static List<CommerceOrder> getPlacedCommerceOrders(long companyId, long groupId, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPlacedCommerceOrders(companyId, groupId, start, end);
    }

    public static List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPlacedCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    public static long getPlacedCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPlacedCommerceOrdersCount(companyId, groupId);
    }

    public static int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPlacedCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    public static List<CommerceOrder> getUserCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserCommerceOrders(companyId, groupId, keywords, start, end);
    }

    public static long getUserCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserCommerceOrdersCount(companyId, groupId, keywords);
    }

    public static List<CommerceOrder> getUserOpenCommerceOrders(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserOpenCommerceOrders(companyId, groupId, keywords, start, end, sort);
    }

    public static List<CommerceOrder> getUserPendingCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserPendingCommerceOrders(companyId, groupId, keywords, start, end);
    }

    public static long getUserPendingCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserPendingCommerceOrdersCount(companyId, groupId, keywords);
    }

    public static List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end);
    }

    public static List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end, Sort sort) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end, sort);
    }

    public static long getUserPlacedCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getUserPlacedCommerceOrdersCount(companyId, groupId, keywords);
    }

    public static void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderServiceUtil.getService().mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public static CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().recalculatePrice(commerceOrderId, commerceContext);
    }

    public static CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().reorderCommerceOrder(commerceOrderId, commerceContext);
    }

    public static CommerceOrder resetCommerceOrderAddresses(long commerceOrderId, boolean billingAddress, boolean shippingAddress) throws PortalException {
        return CommerceOrderServiceUtil.getService().resetCommerceOrderAddresses(commerceOrderId, billingAddress, shippingAddress);
    }

    public static CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean deliveryCommerceTermEntry, boolean paymentCommerceTermEntry) throws PortalException {
        return CommerceOrderServiceUtil.getService().resetTermsAndConditions(commerceOrderId, deliveryCommerceTermEntry, paymentCommerceTermEntry);
    }

    public static CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateBillingAddress(commerceOrderId, billingAddressId);
    }

    public static CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public static CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrder(commerceOrder);
    }

    public static CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal subtotal, BigDecimal total) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, purchaseOrderNumber, shippingAmount, shippingOptionName, subtotal, total);
    }

    public static CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long commerceShippingMethodId, long shippingAddressId, String advanceStatus, String commercePaymentMethodKey, String name, String purchaseOrderNumber, BigDecimal shippingAmount, String shippingOptionName, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, commerceShippingMethodId, shippingAddressId, advanceStatus, commercePaymentMethodKey, name, purchaseOrderNumber, shippingAmount, shippingOptionName, shippingWithTaxAmount, subtotal, subtotalWithTaxAmount, taxAmount, total, totalDiscountAmount, totalWithTaxAmount);
    }

    public static CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrderExternalReferenceCode(externalReferenceCode, commerceOrderId);
    }

    public static CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    public static CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalWithTaxAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalWithTaxAmount) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrderPrices(commerceOrderId, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, shippingDiscountPercentageLevel1WithTaxAmount, shippingDiscountPercentageLevel2WithTaxAmount, shippingDiscountPercentageLevel3WithTaxAmount, shippingDiscountPercentageLevel4WithTaxAmount, shippingDiscountWithTaxAmount, shippingWithTaxAmount, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, subtotalDiscountPercentageLevel1WithTaxAmount, subtotalDiscountPercentageLevel2WithTaxAmount, subtotalDiscountPercentageLevel3WithTaxAmount, subtotalDiscountPercentageLevel4WithTaxAmount, subtotalDiscountWithTaxAmount, subtotalWithTaxAmount, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, totalDiscountPercentageLevel1WithTaxAmount, totalDiscountPercentageLevel2WithTaxAmount, totalDiscountPercentageLevel3WithTaxAmount, totalDiscountPercentageLevel4WithTaxAmount, totalDiscountWithTaxAmount, totalWithTaxAmount);
    }

    public static CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    public static CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceShippingMethod(commerceOrderId, commerceShippingMethodId, commerceShippingOptionName, commerceContext, locale);
    }

    public static CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    public static CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    @Deprecated
    public static CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePaymentStatus(commerceOrderId, paymentStatus);
    }

    @Deprecated
    public static CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePaymentStatusAndTransactionId(commerceOrderId, paymentStatus, transactionId);
    }

    public static CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePrintedNote(commerceOrderId, printedNote);
    }

    public static CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public static CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateShippingAddress(commerceOrderId, shippingAddressId);
    }

    public static CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    public static CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateTermsAndConditions(commerceOrderId, deliveryCommerceTermEntryId, paymentCommerceTermEntryId, languageId);
    }

    public static CommerceOrderService getService() {
        return (CommerceOrderService)_serviceSnapshot.get();
    }
}

