/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceShippingOptionAccountEntryRel service. Represents a row in the &quot;CSOptionAccountEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.model.impl.CommerceShippingOptionAccountEntryRelImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingOptionAccountEntryRel
 * @generated
 */
@ProviderType
public interface CommerceShippingOptionAccountEntryRelModel
	extends AuditedModel, BaseModel<CommerceShippingOptionAccountEntryRel>,
			MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce shipping option account entry rel model instance should use the {@link CommerceShippingOptionAccountEntryRel} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce shipping option account entry rel.
	 *
	 * @return the primary key of this commerce shipping option account entry rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce shipping option account entry rel.
	 *
	 * @param primaryKey the primary key of this commerce shipping option account entry rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this commerce shipping option account entry rel.
	 *
	 * @return the mvcc version of this commerce shipping option account entry rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this commerce shipping option account entry rel.
	 *
	 * @param mvccVersion the mvcc version of this commerce shipping option account entry rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the commerce shipping option account entry rel ID of this commerce shipping option account entry rel.
	 *
	 * @return the commerce shipping option account entry rel ID of this commerce shipping option account entry rel
	 */
	public long getCommerceShippingOptionAccountEntryRelId();

	/**
	 * Sets the commerce shipping option account entry rel ID of this commerce shipping option account entry rel.
	 *
	 * @param CommerceShippingOptionAccountEntryRelId the commerce shipping option account entry rel ID of this commerce shipping option account entry rel
	 */
	public void setCommerceShippingOptionAccountEntryRelId(
		long CommerceShippingOptionAccountEntryRelId);

	/**
	 * Returns the company ID of this commerce shipping option account entry rel.
	 *
	 * @return the company ID of this commerce shipping option account entry rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce shipping option account entry rel.
	 *
	 * @param companyId the company ID of this commerce shipping option account entry rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce shipping option account entry rel.
	 *
	 * @return the user ID of this commerce shipping option account entry rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce shipping option account entry rel.
	 *
	 * @param userId the user ID of this commerce shipping option account entry rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce shipping option account entry rel.
	 *
	 * @return the user uuid of this commerce shipping option account entry rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce shipping option account entry rel.
	 *
	 * @param userUuid the user uuid of this commerce shipping option account entry rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce shipping option account entry rel.
	 *
	 * @return the user name of this commerce shipping option account entry rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce shipping option account entry rel.
	 *
	 * @param userName the user name of this commerce shipping option account entry rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce shipping option account entry rel.
	 *
	 * @return the create date of this commerce shipping option account entry rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce shipping option account entry rel.
	 *
	 * @param createDate the create date of this commerce shipping option account entry rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce shipping option account entry rel.
	 *
	 * @return the modified date of this commerce shipping option account entry rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce shipping option account entry rel.
	 *
	 * @param modifiedDate the modified date of this commerce shipping option account entry rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the account entry ID of this commerce shipping option account entry rel.
	 *
	 * @return the account entry ID of this commerce shipping option account entry rel
	 */
	public long getAccountEntryId();

	/**
	 * Sets the account entry ID of this commerce shipping option account entry rel.
	 *
	 * @param accountEntryId the account entry ID of this commerce shipping option account entry rel
	 */
	public void setAccountEntryId(long accountEntryId);

	/**
	 * Returns the commerce channel ID of this commerce shipping option account entry rel.
	 *
	 * @return the commerce channel ID of this commerce shipping option account entry rel
	 */
	public long getCommerceChannelId();

	/**
	 * Sets the commerce channel ID of this commerce shipping option account entry rel.
	 *
	 * @param commerceChannelId the commerce channel ID of this commerce shipping option account entry rel
	 */
	public void setCommerceChannelId(long commerceChannelId);

	/**
	 * Returns the commerce shipping method key of this commerce shipping option account entry rel.
	 *
	 * @return the commerce shipping method key of this commerce shipping option account entry rel
	 */
	@AutoEscape
	public String getCommerceShippingMethodKey();

	/**
	 * Sets the commerce shipping method key of this commerce shipping option account entry rel.
	 *
	 * @param commerceShippingMethodKey the commerce shipping method key of this commerce shipping option account entry rel
	 */
	public void setCommerceShippingMethodKey(String commerceShippingMethodKey);

	/**
	 * Returns the commerce shipping option key of this commerce shipping option account entry rel.
	 *
	 * @return the commerce shipping option key of this commerce shipping option account entry rel
	 */
	@AutoEscape
	public String getCommerceShippingOptionKey();

	/**
	 * Sets the commerce shipping option key of this commerce shipping option account entry rel.
	 *
	 * @param commerceShippingOptionKey the commerce shipping option key of this commerce shipping option account entry rel
	 */
	public void setCommerceShippingOptionKey(String commerceShippingOptionKey);

	@Override
	public CommerceShippingOptionAccountEntryRel cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}