/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.exception;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CommerceShippingEngineException
extends PortalException {
    public CommerceShippingEngineException() {
    }

    public CommerceShippingEngineException(String msg) {
        super(msg);
    }

    public CommerceShippingEngineException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public CommerceShippingEngineException(Throwable throwable) {
        super(throwable);
    }

    public static class ServerError
    extends CommerceShippingEngineException {
        private final List<KeyValuePair> _errorKVPs;

        public ServerError(List<KeyValuePair> errorKVPs) {
            super("Unable to get reply from server");
            this._errorKVPs = errorKVPs;
        }

        public List<KeyValuePair> getErrorKVPs() {
            return this._errorKVPs;
        }
    }

    public static class MustSetShippingOriginLocator
    extends CommerceShippingEngineException {
        public MustSetShippingOriginLocator(String commerceShippingOriginLocatorKey) {
            super("Unable to get shipping origin locator \"" + commerceShippingOriginLocatorKey + "\"");
        }
    }

    public static class MustSetShippingAddress
    extends CommerceShippingEngineException {
        public MustSetShippingAddress() {
            super("Unable to get shipping address");
        }
    }

    public static class MustSetPrimaryCurrency
    extends CommerceShippingEngineException {
        public MustSetPrimaryCurrency() {
            super("Unable to get primary currency");
        }
    }

    public static class MustSetMeasurementUnit
    extends CommerceShippingEngineException {
        private final List<String> _keys;

        public MustSetMeasurementUnit(String[] keys) {
            super("At least one measurement unit with the following keys must be set: " + StringUtil.merge((Object[])keys, (String)", "));
            this._keys = Collections.unmodifiableList(Arrays.asList(keys));
        }

        public List<String> getKeys() {
            return this._keys;
        }
    }

    public static class MustSetCurrency
    extends CommerceShippingEngineException {
        private final String _code;

        public MustSetCurrency(String code) {
            super("Unable to get currency with code \"" + code + "\"");
            this._code = code;
        }

        public String getCode() {
            return this._code;
        }
    }
}

